/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.events;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.emulator.impl.events.EventPublisher;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.firebase.rules.eventflow.client.EventRuleEvaluatorImpl;
import com.google.firebase.rules.eventflow.client.path.Path;
import com.google.firebase.rules.runtime.evaluators.EventRuleEvaluator;
import com.google.firestore.emulator.v1.EventTrigger;
import com.google.thirdparty.jodatime.JavaTimeConversions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class EventManager {
    public static final String DOCUMENT_CREATE = "providers/cloud.firestore/eventTypes/document.create";
    public static final String DOCUMENT_DELETE = "providers/cloud.firestore/eventTypes/document.delete";
    public static final String DOCUMENT_UPDATE = "providers/cloud.firestore/eventTypes/document.update";
    public static final String DOCUMENT_WRITE = "providers/cloud.firestore/eventTypes/document.write";
    public static final ImmutableSet<String> SUPPORTED_EVENT_TYPES = ImmutableSet.of("providers/cloud.firestore/eventTypes/document.create", "providers/cloud.firestore/eventTypes/document.delete", "providers/cloud.firestore/eventTypes/document.update", "providers/cloud.firestore/eventTypes/document.write");
    public static final String SERVICE_NAME = "firestore.googleapis.com";
    private static final String RULESET_NAME = "";
    private static final Function<String, String> SEGMENT_DECODER = Functions.identity();
    private final String projectId;
    private final EventPublisher eventPublisher;
    private final FirestoreEmulatorConverters converters;

    public EventManager(String projectId, EventPublisher eventPublisher, FirestoreEmulatorConverters converters) {
        this.projectId = projectId;
        this.eventPublisher = eventPublisher;
        this.converters = converters;
    }

    public void reportEvents(ImmutableMap<String, EventTrigger> triggers, Map<EntityRef, EntityReadResult> rowsBefore, Map<EntityRef, EntityReadResult> rowsAfter) throws DatastoreException {
        List flows = triggers.entrySet().stream().map(entry -> EventManager.createFlow((String)entry.getKey(), (EventTrigger)entry.getValue())).collect(ImmutableList.toImmutableList());
        EventRuleEvaluatorImpl evaluator = new EventRuleEvaluatorImpl(RULESET_NAME, flows, SEGMENT_DECODER);
        for (Map.Entry<EntityRef, EntityReadResult> entry2 : rowsBefore.entrySet()) {
            EntityReadResult rowBefore = entry2.getValue();
            EntityReadResult rowAfter = rowsAfter.get(entry2.getKey());
            if (!rowAfter.updatedAt().isPresent()) continue;
            EventRuleEvaluator.EventRuleContext eventRuleContext = EventRuleEvaluator.EventRuleContext.builder().setResource(EventManager.toPath(entry2.getKey())).setEventTypes(EventManager.inferEventTypes(rowBefore, rowAfter)).setTimestamp(JavaTimeConversions.toJodaInstant(rowAfter.updatedAt().get())).build();
            List<EventRuleEvaluator.EventRuleMatch> matches = evaluator.evaluate(eventRuleContext);
            for (EventRuleEvaluator.EventRuleMatch match : matches) {
                String eventType = triggers.get(match.flow().getName()).getEventType();
                EventRuleEvaluator.EventRuleContext publishedContext = eventRuleContext.toBuilder().setEventTypes(ImmutableList.of(eventType)).build();
                this.eventPublisher.publishEvent(this.projectId, match.flow().getName(), publishedContext, this.converters.toDocument(rowBefore), this.converters.toDocument(rowAfter));
            }
        }
    }

    @VisibleForTesting
    static Path toPath(EntityRef entityRef) throws InvalidConversionException {
        String resource = FirestoreV1ResourceRefFromRepConverter.INSTANCE.convertEntityRefServiceRelative(entityRef);
        return Path.segments(Arrays.asList(resource.split("/")));
    }

    private static EventRuleEvaluator.Flow createFlow(String name, EventTrigger trigger) {
        return EventRuleEvaluator.Flow.builder().setName(name).setResource(trigger.getResource()).setEventType(trigger.getEventType()).setService(trigger.getService()).build();
    }

    private static ImmutableList<String> inferEventTypes(EntityReadResult rowBefore, EntityReadResult rowAfter) {
        if (!rowBefore.entity().isPresent()) {
            return ImmutableList.of(DOCUMENT_CREATE, DOCUMENT_WRITE);
        }
        if (!rowAfter.entity().isPresent()) {
            return ImmutableList.of(DOCUMENT_DELETE, DOCUMENT_WRITE);
        }
        if (!rowBefore.updatedAt().equals(rowAfter.updatedAt())) {
            return ImmutableList.of(DOCUMENT_UPDATE, DOCUMENT_WRITE);
        }
        return ImmutableList.of();
    }
}

