/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.events;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.cloud.datastore.emulator.impl.events.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.net.HostAndPort;
import com.google.firebase.rules.runtime.evaluators.EventRuleEvaluator;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.EventFlowDocumentChange;
import com.google.gson.stream.JsonWriter;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JodaTimeConversions;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;

public class FunctionsEmulatorEventPublisher
implements EventPublisher {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher");
    private static final int HTTP_REQUEST_TIMEOUT = 20000;
    private static final Function<String, String> SEGMENT_ENCODER = Functions.identity();
    private final HostAndPort hostAndPort;
    private final HttpTransport httpTransport;
    private final ExecutorService executorService;

    public FunctionsEmulatorEventPublisher(HostAndPort hostAndPort, HttpTransport httpTransport, ExecutorService executorService) {
        this.hostAndPort = hostAndPort;
        this.httpTransport = httpTransport;
        this.executorService = executorService;
    }

    @Override
    public void publishEvent(String projectId, String triggerName, EventRuleEvaluator.EventRuleContext context, @Nullable Document before, @Nullable Document after) {
        byte[] payload;
        try {
            payload = this.generateRequestPayload(context, this.createChangeMessage(before, after));
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher", "publishEvent", 85, "FunctionsEmulatorEventPublisher.java")).log("Failed to format event payload for %s", triggerName);
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher", "publishEvent", 86, "FunctionsEmulatorEventPublisher.java")).log("Failed to format event payload for %s: %s", (Object)triggerName, (Object)e.getMessage());
            return;
        }
        this.executorService.execute(() -> {
            try {
                this.sendHttpRequest(triggerName, payload);
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher", "lambda$publishEvent$0", 96, "FunctionsEmulatorEventPublisher.java")).log("Failed to publish event to %s", this.hostAndPort.toString());
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher", "lambda$publishEvent$0", 98, "FunctionsEmulatorEventPublisher.java")).log("Failed to publish event to %s: %s", (Object)this.hostAndPort.toString(), (Object)e.getMessage());
            }
        });
    }

    @VisibleForTesting
    byte[] generateRequestPayload(EventRuleEvaluator.EventRuleContext context, EventFlowDocumentChange changeMessage) throws IOException {
        String changeJsonStr;
        JsonFormat.Printer printer = JsonFormat.printer().omittingInsignificantWhitespace();
        try {
            changeJsonStr = printer.print(changeMessage);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.beginObject();
            jsonWriter.name("data").jsonValue(changeJsonStr);
            this.writeContextJson(jsonWriter.name("context"), context);
            jsonWriter.endObject();
        }
        return stream.toByteArray();
    }

    private void writeContextJson(JsonWriter jsonWriter, EventRuleEvaluator.EventRuleContext context) throws IOException {
        Preconditions.checkArgument(context.eventTypes().size() == 1, "Context must contain exactly one event type, but got: %s", (Object)context);
        jsonWriter.beginObject();
        jsonWriter.name("eventId").value(context.eventId());
        jsonWriter.name("timestamp").value(Timestamps.toString(JodaTimeConversions.toProtoTimestamp(context.timestamp().get())));
        jsonWriter.name("eventType").value((String)context.eventTypes().get(0));
        jsonWriter.name("resource").beginObject();
        jsonWriter.name("name").value(context.resource().toPath(SEGMENT_ENCODER));
        jsonWriter.name("service").value("firestore.googleapis.com");
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    @VisibleForTesting
    void sendHttpRequest(String triggerName, byte[] payload) throws IOException {
        GenericUrl url = new GenericUrl();
        url.setScheme("http");
        url.setHost(this.hostAndPort.getHost());
        url.setPort(this.hostAndPort.getPort());
        String string = String.valueOf(triggerName);
        url.setRawPath(string.length() != 0 ? "/functions/".concat(string) : new String("/functions/"));
        HttpRequest httpRequest = this.httpTransport.createRequestFactory().buildPostRequest(url, new ByteArrayContent("application/json", payload));
        httpRequest.setThrowExceptionOnExecuteError(false);
        httpRequest.setConnectTimeout(20000);
        httpRequest.setReadTimeout(20000);
        HttpResponse httpResponse = httpRequest.execute();
        if (!httpResponse.isSuccessStatusCode()) {
            HttpResponseException httpResponseException = new HttpResponseException(httpResponse);
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(httpResponseException)).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher", "sendHttpRequest", 169, "FunctionsEmulatorEventPublisher.java")).log("Unsuccessful HTTP response when publishing event for %s", triggerName);
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/impl/events/FunctionsEmulatorEventPublisher", "sendHttpRequest", 171, "FunctionsEmulatorEventPublisher.java")).log("Unsuccessful HTTP response when publishing event for %s: %s", (Object)triggerName, (Object)httpResponseException.getMessage());
        }
        httpResponse.disconnect();
    }

    @VisibleForTesting
    EventFlowDocumentChange createChangeMessage(@Nullable Document before, @Nullable Document after) {
        EventFlowDocumentChange.Builder builder = EventFlowDocumentChange.newBuilder();
        if (before != null) {
            builder.setOldValue(before);
        }
        if (after != null) {
            builder.setValue(after);
        }
        builder.setUpdateMask(DocumentMask.getDefaultInstance());
        return builder.build();
    }
}

