/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_FirestoreEmulatorQueryExecutor_IndexTableScan;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQueryPlanner;
import com.google.cloud.datastore.emulator.impl.queries.IndexEntry;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;

public final class FirestoreEmulatorQueryExecutor {
    private FirestoreEmulatorQueryExecutor() {
    }

    static ImmutableList<EntityRef> performScans(ImmutableList<IndexTableScan> tableScans, Comparator<IndexEntry> postfixComparator, int offset, Optional<Integer> limit) {
        ArrayList indexEntryScanners = new ArrayList();
        for (IndexTableScan tableScan : tableScans) {
            FirestoreEmulatorQueryPlanner.IndexEntryRange range = tableScan.range();
            indexEntryScanners.add(tableScan.indexTable().subSet(range.lo().value(), range.lo().before(), range.hi().value(), !range.hi().before()).iterator());
        }
        UnionIterator<IndexEntry> union = new UnionIterator<IndexEntry>(indexEntryScanners, postfixComparator);
        Iterators.advance(union, offset);
        Iterator<IndexEntry> limited = Iterators.limit(union, limit.orElse(Integer.MAX_VALUE));
        return ImmutableList.copyOf(Iterators.transform(limited, IndexEntry::entityRef));
    }

    static NavigableSet<IndexEntry> materializeIndexTable(List<Entity> entities, IndexDef indexDef, EntityRef parent) {
        return entities.stream().filter(e -> indexDef.appliesToKind(e.ref().collectionId())).filter(e -> FirestoreEmulatorQueryExecutor.matchesIndexAncestor(indexDef.indexAncestor(), e.ref(), parent)).flatMap(e -> IndexEntry.createForIndex(e, indexDef)).collect(ImmutableSortedSet.toImmutableSortedSet(IndexEntry.Comparator.forIndexDef(indexDef)));
    }

    static ImmutableList<Entity> lookupEntities(ImmutableList<EntityRef> entityKeys, ImmutableList<Entity> entities) {
        ImmutableMap refToEntity = Maps.uniqueIndex(entities, Entity::ref);
        return entityKeys.stream().map(refToEntity::get).collect(ImmutableList.toImmutableList());
    }

    private static boolean matchesIndexAncestor(IndexDef.IndexAncestor indexAncestor, EntityRef ref, EntityRef target) {
        switch (indexAncestor) {
            case ANCESTOR: {
                return FirestoreEmulatorQueryExecutor.hasAncestor(ref, target);
            }
            case PARENT: {
                return target.equals(ref.parent());
            }
            case NONE: {
                throw new UnsupportedOperationException("IndexAncestor should always be ANCESTOR or PARENT");
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static boolean hasAncestor(EntityRef ref, EntityRef target) {
        do {
            if (!(ref = ref.parent()).equals(target)) continue;
            return true;
        } while (!ref.path().isEmpty());
        return false;
    }

    private static class UnionIterator<T>
    extends AbstractIterator<T> {
        final Iterator<T> iterator;
        final Comparator<? super T> cmp;
        T lastSeen = null;

        UnionIterator(Iterable<Iterator<T>> iterator, Comparator<? super T> cmp) {
            this.iterator = Iterators.mergeSorted(iterator, cmp);
            this.cmp = cmp;
        }

        @Override
        protected T computeNext() {
            while (this.iterator.hasNext()) {
                T next = this.iterator.next();
                if (this.lastSeen != null && this.cmp.compare(this.lastSeen, next) == 0) continue;
                this.lastSeen = next;
                return next;
            }
            this.lastSeen = null;
            return this.endOfData();
        }
    }

    @AutoValue
    public static abstract class IndexTableScan {
        public abstract NavigableSet<IndexEntry> indexTable();

        public abstract FirestoreEmulatorQueryPlanner.IndexEntryRange range();

        public static IndexTableScan of(NavigableSet<IndexEntry> table, FirestoreEmulatorQueryPlanner.IndexEntryRange range) {
            return new AutoValue_FirestoreEmulatorQueryExecutor_IndexTableScan(table, range);
        }
    }
}

