/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.apphosting.datastore.shared.Config;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.query.ConditionNormalizer;
import com.google.cloud.datastore.core.query.NormalizedQuery;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import com.google.cloud.datastore.core.rep.PropertyCondition;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.PropertyValueCondition;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_FirestoreEmulatorQueryPlanner_IndexEntryBound;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_FirestoreEmulatorQueryPlanner_IndexEntryRange;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_FirestoreEmulatorQueryPlanner_PerfectQueryPlan;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_FirestoreEmulatorQueryPlanner_PostfixCondition;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_FirestoreEmulatorQueryPlanner_PrefixEquality;
import com.google.cloud.datastore.emulator.impl.queries.IndexEntry;
import com.google.cloud.datastore.emulator.impl.queries.IndexRange;
import com.google.cloud.datastore.emulator.impl.util.ConditionVisitorBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class FirestoreEmulatorQueryPlanner {
    private final ConditionNormalizer conditionNormalizer;

    public FirestoreEmulatorQueryPlanner(Config.DatastoreConfig config) {
        this.conditionNormalizer = new ConditionNormalizer(config.getMaxQueryDisjunctions());
    }

    void validate(Query query) {
        Preconditions.checkArgument(query.semantics().equals((Object)Query.Semantics.FIRESTORE), "expected Firestore query semantics but got %s", (Object)query.semantics());
        Preconditions.checkArgument(query.isShallow() || query.ancestor() == null || FirestoreEmulatorQueryPlanner.isAscendingPrimaryKeyScan(query), "collection group queries are only allowed if they're at the root or they're an ascending primary key scan");
        this.checkDisjunctions(query.condition());
        int conditionPaths = FirestoreEmulatorQueryPlanner.maxArrayContainsConditions(query.condition());
        Preconditions.checkArgument(conditionPaths <= 1, "Only a single array-contains clause is allowed in a query");
        FirestoreEmulatorQueryPlanner.validateOrderBys(query.orderBy());
    }

    private int checkDisjunctions(@Nullable Condition condition) {
        if (condition == null) {
            return 0;
        }
        if (condition instanceof LogicalCondition) {
            int orCount = ((LogicalCondition)condition).subConditions().stream().mapToInt(this::checkDisjunctions).sum();
            Preconditions.checkArgument(orCount <= 1, "Only a single IN clause is allowed.");
            return orCount;
        }
        return 0;
    }

    private static boolean isAscendingPrimaryKeyScan(Query query) {
        boolean hasOnlyKeyOrderBys = query.orderBy().stream().allMatch(path -> path.propertyPath().isKey() && path.direction() == Direction.ASCENDING);
        ArrayList conditions = new ArrayList();
        new ConditionVisitorBuilder().match(PropertyCondition.class, conditions::add).build().visitLeafConditions(query.condition());
        boolean hasOnlyKeyConditions = conditions.stream().allMatch(c -> c.propertyPath().isKey());
        return hasOnlyKeyOrderBys && hasOnlyKeyConditions;
    }

    private static int maxArrayContainsConditions(@Nullable Condition condition) {
        if (condition == null) {
            return 0;
        }
        if (condition instanceof LogicalCondition) {
            IntStream arrayContainsCounts = ((LogicalCondition)condition).subConditions().stream().mapToInt(FirestoreEmulatorQueryPlanner::maxArrayContainsConditions);
            return condition.op() == Condition.Op.OR ? arrayContainsCounts.max().orElse(0) : arrayContainsCounts.sum();
        }
        if (condition instanceof PropertyCondition) {
            return ((PropertyCondition)condition).propertyPath().isArrayElements() ? 1 : 0;
        }
        return 0;
    }

    private static void validateOrderBys(ImmutableList<PropertyPathWithDirection> orderBy) {
        HashSet<PropertyPath> orderByPaths = new HashSet<PropertyPath>();
        for (PropertyPathWithDirection pathWithDirection : orderBy) {
            Preconditions.checkArgument(!orderByPaths.contains(PropertyPath.KEY), "order by clause cannot contain more fields after the key");
            PropertyPath path = pathWithDirection.propertyPath();
            Preconditions.checkArgument(!path.isArrayElements(), "order by clause cannot contain multi-value fields %s", (Object)path);
            boolean uniquePath = orderByPaths.add(path);
            Preconditions.checkArgument(uniquePath, "order by clause cannot contain duplicate fields %s", (Object)path);
        }
    }

    Query normalize(Query query) throws ValidationException {
        try {
            return query.toBuilder().orderBy(FirestoreEmulatorQueryPlanner.normalizeOrderBy(query)).condition(this.conditionNormalizer.toDisjunctiveNormalForm(query.condition())).build();
        }
        catch (ValidationException e) {
            throw new ValidationException("Too many IN clauses, only up to 10 values are allowed.", e);
        }
    }

    private static ImmutableList<PropertyPathWithDirection> normalizeOrderBy(Query query) {
        ImmutableList.Builder normalized = ImmutableList.builder();
        Direction lastDirection = Direction.ASCENDING;
        HashSet<PropertyPath> orderedProperties = new HashSet<PropertyPath>();
        for (PropertyPathWithDirection orderBy : query.orderBy()) {
            normalized.add(orderBy);
            lastDirection = orderBy.direction();
            orderedProperties.add(orderBy.propertyPath());
        }
        ArrayList<Object> missingInequalityProperties = new ArrayList<Object>();
        new ConditionVisitorBuilder().match(PropertyValueCondition.class, c -> {
            switch (c.op()) {
                case LT: 
                case LE: 
                case GE: 
                case GT: {
                    if (orderedProperties.contains(c.propertyPath())) break;
                    orderedProperties.add(c.propertyPath());
                    missingInequalityProperties.add(c.propertyPath());
                    break;
                }
            }
        }).build().visitLeafConditions(query.condition());
        missingInequalityProperties.sort(Comparator.naturalOrder());
        if (!orderedProperties.contains(PropertyPath.KEY)) {
            missingInequalityProperties.add(PropertyPath.KEY);
        }
        for (PropertyPath propertyPath : missingInequalityProperties) {
            normalized.add(PropertyPathWithDirection.create(propertyPath, lastDirection));
        }
        return normalized.build();
    }

    ImmutableSet<PerfectQueryPlan> planQuery(Query query) {
        Preconditions.checkArgument(!query.orderBy().isEmpty(), "Queries must at least orderBy __name__.");
        ImmutableList<IndexDef.PropertyDef> postfix = query.orderBy().stream().map(path -> IndexDef.PropertyDef.create(path.propertyPath(), IndexDef.PropertyDef.Mode.ORDERED, path.direction())).collect(ImmutableList.toImmutableList());
        PropertyPath postfixHead = ((IndexDef.PropertyDef)postfix.get(0)).path();
        ImmutableSet.Builder plans = ImmutableSet.builder();
        for (Condition condition : NormalizedQuery.disjunctions(query)) {
            IndexEntryBound forCursor;
            IndexEntryBound forCursor2;
            ImmutableList.Builder equalities = ImmutableList.builder();
            ImmutableList.Builder inequalities = ImmutableList.builder();
            new ConditionVisitorBuilder().match(LogicalCondition.class, Condition.Op.AND, ignored -> {}).match(PropertyValueCondition.class, ImmutableSet.of(Condition.Op.EQ, Condition.Op.REALLY_EQUALS), c -> {
                if (c.propertyPath().equals(postfixHead)) {
                    inequalities.add(PostfixCondition.of(c.op(), c.value()));
                } else {
                    equalities.add(PrefixEquality.of(c.op(), c.propertyPath(), c.value()));
                }
            }).match(PropertyValueCondition.class, c -> {
                Preconditions.checkArgument(c.propertyPath().equals(postfixHead), "found %s condition on %s, but properties with inequality conditions must be the first order by element (%s)", (Object)c.op(), (Object)c.propertyPath(), (Object)postfixHead);
                inequalities.add(PostfixCondition.of(c.op(), c.value()));
            }).orElse(other -> {
                String string = String.valueOf((Object)other.op());
                throw new UnsupportedOperationException(new StringBuilder(24 + String.valueOf(string).length()).append("Unrecognized condition: ").append(string).toString());
            }).build().visitAllConditions(condition);
            ImmutableCollection prefix = equalities.build();
            IndexDef indexDef = FirestoreEmulatorQueryPlanner.makeIndexDef(query.kind(), query.isShallow(), (ImmutableList<PrefixEquality>)prefix, postfix);
            ImmutableList<Direction> directions = indexDef.propertyDefs().stream().map(IndexDef.PropertyDef::direction).collect(ImmutableList.toImmutableList());
            ImmutableList<IndexRange.ValueRange> valueRanges = FirestoreEmulatorQueryPlanner.constructValueRanges((ImmutableList<PrefixEquality>)prefix, postfix, (ImmutableList<PostfixCondition>)inequalities.build());
            Comparator<IndexEntryBound> comparator = Comparator.comparing(IndexEntryBound::value, IndexEntry.Comparator.forIndexDef(indexDef)).thenComparing(IndexEntryBound::before, Comparator.reverseOrder());
            IndexEntryBound lo = FirestoreEmulatorQueryPlanner.lowerBound(valueRanges, directions);
            if (query.startCursor() != null && comparator.compare(lo, forCursor2 = FirestoreEmulatorQueryPlanner.cursorBound(query.startCursor(), (ImmutableList<PrefixEquality>)prefix, directions)) < 0) {
                lo = forCursor2;
            }
            IndexEntryBound hi = FirestoreEmulatorQueryPlanner.upperBound(valueRanges, directions);
            if (query.endCursor() != null && comparator.compare(hi, forCursor = FirestoreEmulatorQueryPlanner.cursorBound(query.endCursor(), (ImmutableList<PrefixEquality>)prefix, directions)) > 0) {
                hi = forCursor;
            }
            if (comparator.compare(lo, hi) > 0) continue;
            plans.add(PerfectQueryPlan.of(indexDef, postfix, IndexEntryRange.of(lo, hi)));
        }
        return plans.build();
    }

    private static IndexDef makeIndexDef(@Nullable String kind, boolean shallow, ImmutableList<PrefixEquality> prefix, ImmutableList<IndexDef.PropertyDef> postfix) {
        return IndexDef.builder().semantics(Query.Semantics.FIRESTORE).indexAncestor(shallow ? IndexDef.IndexAncestor.PARENT : IndexDef.IndexAncestor.ANCESTOR).kind(kind).propertyDefs(Stream.concat(prefix.stream().map(eq -> IndexDef.PropertyDef.create(eq.path(), IndexDef.PropertyDef.Mode.ORDERED, Direction.ASCENDING)), postfix.stream()).collect(ImmutableList.toImmutableList())).build();
    }

    private static ImmutableList<IndexRange.ValueRange> constructValueRanges(ImmutableList<PrefixEquality> prefix, ImmutableList<IndexDef.PropertyDef> postfix, ImmutableList<PostfixCondition> inequalities) {
        ImmutableList.Builder builder = ImmutableList.builder();
        prefix.stream().map(eq -> IndexRange.ValueRange.fromCondition(eq.op(), eq.value())).forEach(builder::add);
        IndexRange.ValueRange accum = IndexRange.ValueRange.OPEN;
        for (PostfixCondition c : inequalities) {
            accum = IndexRange.ValueRange.intersection(accum, IndexRange.ValueRange.fromCondition(c.op(), c.value()));
        }
        builder.add(accum);
        postfix.stream().skip(1L).map(orderBy -> IndexRange.ValueRange.OPEN).forEach(builder::add);
        return builder.build();
    }

    private static IndexEntryBound lowerBound(ImmutableList<IndexRange.ValueRange> ranges, ImmutableList<Direction> directions) {
        ArrayList<IndexValue> values = new ArrayList<IndexValue>();
        boolean before = true;
        block4: for (int i = 0; i < ranges.size(); ++i) {
            boolean isKey = i + 1 == ranges.size();
            switch ((Direction)((Object)directions.get(i))) {
                case ASCENDING: {
                    IndexRange.ValueBound lo = ((IndexRange.ValueRange)ranges.get(i)).lo();
                    values.add(before ? FirestoreEmulatorQueryPlanner.toIndexValue(lo.value(), !isKey) : null);
                    if (lo.bias() != IndexRange.Bias.HIGH) continue block4;
                    before = false;
                    continue block4;
                }
                case DESCENDING: {
                    IndexRange.ValueBound hi = ((IndexRange.ValueRange)ranges.get(i)).hi();
                    values.add(before ? FirestoreEmulatorQueryPlanner.toIndexValue(hi.value(), !isKey) : IndexValue.ABSENT);
                    if (hi.bias() != IndexRange.Bias.LOW) continue block4;
                    before = false;
                }
            }
        }
        return IndexEntryBound.of(IndexEntry.of(EntityRef.EMPTY, values), before);
    }

    private static IndexEntryBound upperBound(ImmutableList<IndexRange.ValueRange> ranges, ImmutableList<Direction> directions) {
        IndexEntryBound flipped = FirestoreEmulatorQueryPlanner.lowerBound(ranges, directions.stream().map(Direction::flip).collect(ImmutableList.toImmutableList()));
        return IndexEntryBound.of(flipped.value(), !flipped.before());
    }

    private static IndexEntryBound cursorBound(Cursor cursor, ImmutableList<PrefixEquality> prefix, ImmutableList<Direction> directions) {
        Preconditions.checkArgument(prefix.size() + cursor.indexValues().size() + 1 <= directions.size());
        List<IndexValue> values = prefix.stream().map(pre -> FirestoreEmulatorQueryPlanner.toIndexValue(pre.value(), true)).collect(Collectors.toList());
        for (UnifiedIndexValue value : cursor.indexValues()) {
            values.add(value.indexValue());
        }
        for (int i = values.size(); i < directions.size() - 1; ++i) {
            values.add(FirestoreEmulatorQueryPlanner.indexValueBound((Direction)((Object)directions.get(i)), cursor.before()));
        }
        values.add(cursor.key() != null ? FirestoreEmulatorQueryPlanner.toIndexValue(cursor.key()) : FirestoreEmulatorQueryPlanner.indexValueBound(Iterables.getLast(directions), cursor.before()));
        return IndexEntryBound.of(IndexEntry.of(EntityRef.EMPTY, values), cursor.before());
    }

    private static IndexValue toIndexValue(@Nullable Value v, boolean truncate) {
        return v == null ? null : (truncate ? ValueToFirestoreIndexValueConverter.DEFAULT.convertValueTruncateIfThresholdExceeded(v) : ValueToFirestoreIndexValueConverter.DEFAULT.convertValueIgnoreThreshold(v));
    }

    private static IndexValue toIndexValue(EntityRef ref) {
        return ValueToFirestoreIndexValueConverter.DEFAULT.convertEntityRefIgnoreThreshold(ref);
    }

    private static IndexValue indexValueBound(Direction dir, boolean before) {
        switch (before ? dir : dir.flip()) {
            case ASCENDING: {
                return IndexValue.ABSENT;
            }
            case DESCENDING: {
                return null;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    @AutoValue
    static abstract class PostfixCondition {
        PostfixCondition() {
        }

        abstract Condition.Op op();

        abstract Value value();

        static PostfixCondition of(Condition.Op op, Value value) {
            return new AutoValue_FirestoreEmulatorQueryPlanner_PostfixCondition(op, value);
        }
    }

    @AutoValue
    static abstract class PrefixEquality {
        PrefixEquality() {
        }

        abstract PropertyPath path();

        abstract Value value();

        abstract Condition.Op op();

        static PrefixEquality of(Condition.Op op, PropertyPath path, Value value) {
            Preconditions.checkArgument(op.equals((Object)Condition.Op.EQ) || op.equals((Object)Condition.Op.REALLY_EQUALS), "PrefixEquality only makes sense with EQ or REALLY_EQUALS");
            return new AutoValue_FirestoreEmulatorQueryPlanner_PrefixEquality(path, value, op);
        }
    }

    @AutoValue
    static abstract class IndexEntryRange {
        IndexEntryRange() {
        }

        abstract IndexEntryBound lo();

        abstract IndexEntryBound hi();

        static IndexEntryRange of(IndexEntryBound lo, IndexEntryBound hi) {
            return new AutoValue_FirestoreEmulatorQueryPlanner_IndexEntryRange(lo, hi);
        }
    }

    @AutoValue
    static abstract class IndexEntryBound {
        IndexEntryBound() {
        }

        @Nullable
        abstract IndexEntry value();

        abstract boolean before();

        static IndexEntryBound of(IndexEntry value, boolean before) {
            return new AutoValue_FirestoreEmulatorQueryPlanner_IndexEntryBound(value, before);
        }
    }

    @AutoValue
    static abstract class PerfectQueryPlan {
        PerfectQueryPlan() {
        }

        abstract IndexDef index();

        abstract Comparator<IndexEntry> postfixComparator();

        abstract IndexEntryRange range();

        static PerfectQueryPlan of(IndexDef index, ImmutableList<IndexDef.PropertyDef> postfix, IndexEntryRange range) {
            int prefixSize = index.propertyDefs().size() - postfix.size();
            return new AutoValue_FirestoreEmulatorQueryPlanner_PerfectQueryPlan(index, IndexEntry.Comparator.forPostfix(prefixSize, postfix), range);
        }
    }
}

