/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQueryExecutor;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQueryPlanner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Optional;

public final class FirestoreEmulatorQuerySemantics {
    private final FirestoreEmulatorQueryPlanner planner;

    public FirestoreEmulatorQuerySemantics(Config.DatastoreConfig datastoreConfig) {
        this.planner = new FirestoreEmulatorQueryPlanner(datastoreConfig);
    }

    public ImmutableList<Entity> runQuery(ImmutableList<Entity> entities, Query query) throws ValidationException {
        this.planner.validate(query);
        Query normalized = this.planner.normalize(query);
        EntityRef parent = Optional.ofNullable(normalized.ancestor()).orElseGet(() -> EntityRef.createEmpty(normalized.scope().partition()));
        ImmutableSet<FirestoreEmulatorQueryPlanner.PerfectQueryPlan> perfectQueryPlans = this.planner.planQuery(normalized);
        if (perfectQueryPlans.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList<FirestoreEmulatorQueryExecutor.IndexTableScan> indexTableScans = perfectQueryPlans.stream().map(scan -> FirestoreEmulatorQueryExecutor.IndexTableScan.of(FirestoreEmulatorQueryExecutor.materializeIndexTable(entities, scan.index(), parent), scan.range())).collect(ImmutableList.toImmutableList());
        ImmutableList<EntityRef> entityKeys = FirestoreEmulatorQueryExecutor.performScans(indexTableScans, Preconditions.checkNotNull(Iterables.getFirst(perfectQueryPlans, null)).postfixComparator(), normalized.offset(), Optional.ofNullable(normalized.limit()));
        return FirestoreEmulatorQueryExecutor.lookupEntities(entityKeys, entities);
    }
}

