/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.index.firestore.FirestoreIndexValueComparator;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_IndexEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

@AutoValue
public abstract class IndexEntry {
    abstract EntityRef entityRef();

    abstract List<IndexValue> indexValues();

    static IndexEntry of(EntityRef ref, List<IndexValue> indexValues) {
        return new AutoValue_IndexEntry(ref, indexValues);
    }

    static Stream<IndexEntry> createForIndex(Entity entity, IndexDef indexDef) {
        MultiValueBuilder builder = new MultiValueBuilder(entity.ref());
        for (IndexDef.PropertyDef p : indexDef.propertyDefs()) {
            Value value;
            if (p.path().isKey()) {
                builder.addValue(ValueToFirestoreIndexValueConverter.DEFAULT.convertEntityRefIgnoreThreshold(entity.ref()));
                continue;
            }
            if (p.path().isArrayElements()) {
                value = entity.get(p.path().dropLastPathSegment());
                if (value == null || value.type() != Value.Type.ARRAY || value.asArray().isEmpty()) {
                    return Stream.empty();
                }
                builder.forkValues(value.asArray().stream().map(ValueToFirestoreIndexValueConverter.DEFAULT::convertValueTruncateIfThresholdExceeded).collect(ImmutableList.toImmutableList()));
                continue;
            }
            value = entity.get(p.path());
            if (value == null) {
                return Stream.empty();
            }
            builder.addValue(ValueToFirestoreIndexValueConverter.DEFAULT.convertValueTruncateIfThresholdExceeded(value));
        }
        return builder.build();
    }

    static class Comparator
    implements java.util.Comparator<IndexEntry> {
        private final int prefixSize;
        private final ImmutableList<Direction> directions;

        private Comparator(int prefixSize, Iterable<Direction> directions) {
            this.prefixSize = prefixSize;
            this.directions = ImmutableList.copyOf(directions);
        }

        static Comparator forIndexDef(IndexDef indexDef) {
            return new Comparator(0, indexDef.propertyDefs().stream().map(IndexDef.PropertyDef::direction).collect(ImmutableList.toImmutableList()));
        }

        static Comparator forPostfix(int prefixSize, ImmutableList<IndexDef.PropertyDef> postfixDef) {
            return new Comparator(prefixSize, postfixDef.stream().map(IndexDef.PropertyDef::direction).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public int compare(IndexEntry left, IndexEntry right) {
            Preconditions.checkArgument(left.indexValues().size() == this.directions.size() + this.prefixSize && right.indexValues().size() == this.directions.size() + this.prefixSize, "IndexEntries must have one index value for every property def in its corresponding perfect index definition.");
            int i = 0;
            int j = this.prefixSize;
            while (i < this.directions.size()) {
                int comparisonResult = FirestoreIndexValueComparator.INSTANCE.compare(left.indexValues().get(j), right.indexValues().get(j));
                if (comparisonResult != 0) {
                    return this.directions.get(i) == Direction.DESCENDING ? -comparisonResult : comparisonResult;
                }
                ++i;
                ++j;
            }
            return 0;
        }
    }

    private static final class MultiValueBuilder {
        private final EntityRef ref;
        private List<List<IndexValue>> indexEntries;

        MultiValueBuilder(EntityRef ref) {
            this.ref = ref;
            this.indexEntries = new ArrayList<List<IndexValue>>();
            this.indexEntries.add(new ArrayList());
        }

        void addValue(IndexValue value) {
            for (List<IndexValue> entries : this.indexEntries) {
                entries.add(value);
            }
        }

        void forkValues(Collection<IndexValue> values) {
            ArrayList<List<IndexValue>> newIndexEntries = new ArrayList<List<IndexValue>>(this.indexEntries.size() * values.size());
            for (List<IndexValue> oldEntry : this.indexEntries) {
                for (IndexValue value : values) {
                    ArrayList<IndexValue> newEntry = new ArrayList<IndexValue>(oldEntry);
                    newEntry.add(value);
                    newIndexEntries.add(newEntry);
                }
            }
            this.indexEntries = newIndexEntries;
        }

        Stream<IndexEntry> build() {
            return this.indexEntries.stream().map(values -> IndexEntry.of(this.ref, values));
        }
    }
}

