/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.order.FirestoreValueOrder;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_IndexRange_ValueBound;
import com.google.cloud.datastore.emulator.impl.queries.AutoValue_IndexRange_ValueRange;
import java.util.Comparator;
import javax.annotation.Nullable;

class IndexRange {
    private static final FirestoreValueOrder ORDERING = FirestoreValueOrder.INSTANCE;

    private IndexRange() {
    }

    @AutoValue
    static abstract class ValueRange {
        static final ValueRange OPEN = ValueRange.between(ValueBound.MIN, ValueBound.MAX);
        static final ValueRange EMPTY = ValueRange.between(ValueBound.MIN, ValueBound.MIN);

        ValueRange() {
        }

        abstract ValueBound lo();

        abstract ValueBound hi();

        static ValueRange between(ValueBound lo, ValueBound hi) {
            return new AutoValue_IndexRange_ValueRange(lo, hi);
        }

        static ValueRange exactly(Value value) {
            return ValueRange.between(ValueBound.below(value), ValueBound.above(value));
        }

        static ValueRange fromCondition(Condition.Op op, Value value) {
            if (value.equals(Value.NAN) && op != Condition.Op.REALLY_EQUALS) {
                return EMPTY;
            }
            switch (op) {
                case LT: {
                    return ValueRange.between(ValueBound.below(ORDERING.minValueOfCategory(value)), ValueBound.below(value));
                }
                case LE: {
                    return ValueRange.between(ValueBound.below(ORDERING.minValueOfCategory(value)), ValueBound.above(value));
                }
                case REALLY_EQUALS: 
                case EQ: {
                    return ValueRange.exactly(value);
                }
                case GE: {
                    return ValueRange.between(ValueBound.below(value), ValueBound.below(ORDERING.minValueOfNextCategory(value)));
                }
                case GT: {
                    return ValueRange.between(ValueBound.above(value), ValueBound.below(ORDERING.minValueOfNextCategory(value)));
                }
            }
            String string = String.valueOf((Object)op);
            throw new IllegalArgumentException(new StringBuilder(17 + String.valueOf(string).length()).append("Unrecognized Op: ").append(string).toString());
        }

        static ValueRange intersection(ValueRange a, ValueRange b) {
            return ValueRange.between(ValueBound.max(a.lo(), b.lo()), ValueBound.min(a.hi(), b.hi()));
        }
    }

    @AutoValue
    static abstract class ValueBound {
        static final ValueBound MIN = ValueBound.below(FirestoreValueOrder.MIN_VALUE);
        static final ValueBound MAX = ValueBound.above(null);
        static final Comparator<ValueBound> INSTANCE = Comparator.comparing(ValueBound::value, IndexRange.access$000()).thenComparing(ValueBound::bias);

        ValueBound() {
        }

        @Nullable
        abstract Value value();

        abstract Bias bias();

        private static ValueBound of(Value value, Bias bias) {
            return new AutoValue_IndexRange_ValueBound(value, bias);
        }

        static ValueBound below(Value value) {
            return ValueBound.of(value, Bias.LOW);
        }

        static ValueBound above(Value value) {
            return ValueBound.of(value, Bias.HIGH);
        }

        static ValueBound min(ValueBound a, ValueBound b) {
            return INSTANCE.compare(a, b) < 0 ? a : b;
        }

        static ValueBound max(ValueBound a, ValueBound b) {
            return INSTANCE.compare(a, b) > 0 ? a : b;
        }
    }

    static enum Bias {
        LOW,
        HIGH;

    }
}

