/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.rules;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.runtime.common.EvaluationRestrictions;
import com.google.firebase.rules.runtime.common.EvaluationResult;
import com.google.firebase.rules.runtime.evaluators.AuthRuleEvaluator;
import com.google.firebase.rules.runtime.evaluators.EventRuleEvaluator;
import com.google.firebase.rules.runtime.evaluators.RuleClient;
import com.google.firebase.rules.runtime.impl.DefaultEvaluator;
import com.google.firebase.rules.runtime.tracking.GranularExpressionListener;
import com.google.firebase.rules.runtime.tracking.PermissionTrace;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;

class EmulatorRuleClient
implements RuleClient {
    private final RulesetAst rulesetAst;
    private final ConcurrentLinkedQueue<PermissionTrace> traces = new ConcurrentLinkedQueue();

    public EmulatorRuleClient(RulesetAst rulesetAst) {
        this.rulesetAst = rulesetAst;
    }

    public Collection<PermissionTrace> permissionTraces() {
        return this.traces;
    }

    @Override
    public EmulatorRuleEvaluator getEvaluator(AuthRuleEvaluator.AuthRuleEvaluatorRequest request) {
        return new EmulatorRuleEvaluator(this.rulesetAst, request.releaseName(), this.traces);
    }

    @Override
    public EventRuleEvaluator getEvaluator(EventRuleEvaluator.EventRuleEvaluatorRequest request) {
        throw new UnsupportedOperationException("Emulator does not support EventRuleEvaluators");
    }

    public static final class DebugRuleResult
    implements AuthRuleEvaluator.RuleResult {
        private final boolean underlying;
        final ImmutableList<PermissionTrace> debugMessages;

        DebugRuleResult(boolean underlying, GranularExpressionListener debugger) {
            this.underlying = underlying;
            this.debugMessages = debugger.traces();
        }

        @Override
        public boolean permit() {
            return this.underlying;
        }
    }

    @VisibleForTesting
    static final class EmulatorRuleEvaluator
    implements AuthRuleEvaluator {
        private final ConcurrentLinkedQueue<PermissionTrace> traces;
        private final RulesetAst rulesetAst;
        private final String releaseName;

        private EmulatorRuleEvaluator(RulesetAst rulesetAst, String releaseName, ConcurrentLinkedQueue<PermissionTrace> traces) {
            this.rulesetAst = rulesetAst;
            this.releaseName = releaseName;
            this.traces = traces;
        }

        @Override
        public ListenableFuture<AuthRuleEvaluator.RuleResult> evaluate(AuthRuleEvaluator.RuleContext ... contexts) {
            return this.evaluate(ImmutableList.copyOf(contexts));
        }

        @Override
        public ListenableFuture<AuthRuleEvaluator.RuleResult> evaluate(List<AuthRuleEvaluator.RuleContext> contexts) {
            GranularExpressionListener debugger = new GranularExpressionListener(this.traces);
            DefaultEvaluator evaluator = new DefaultEvaluator(this.rulesetAst, ImmutableList.of(Suppliers.ofInstance(debugger)), EvaluationRestrictions.builder().build());
            ListenableFuture<EvaluationResult> evaluationResultFuture = evaluator.evaluate(ImmutableList.copyOf(contexts));
            return Futures.transform(evaluationResultFuture, evaluationResult -> new DebugRuleResult(Objects.requireNonNull(evaluationResult).permit(), debugger), MoreExecutors.directExecutor());
        }

        @Override
        public String getRulesetName() {
            return this.releaseName;
        }

        @Override
        public RulesetAst getRulesetAst() {
            return this.rulesetAst;
        }
    }
}

