/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.rules;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.auth.rules.DatastoreRuleContextBuilder;
import com.google.cloud.datastore.core.auth.rules.DebugFunction;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.FirebaseRulesAuthorizerOptions;
import com.google.cloud.datastore.core.auth.rules.LookupsToAuthorize;
import com.google.cloud.datastore.core.auth.rules.RulesAccessCollector;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.auth.rules.SinglePhaseRulesAuthorizer;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.stats.GenericStats;
import com.google.cloud.datastore.core.util.DatastoreConsumer;
import com.google.cloud.datastore.emulator.impl.context.EmulatorAuthorization;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import com.google.cloud.datastore.emulator.impl.rules.EmulatorRuleClient;
import com.google.cloud.datastore.emulator.impl.rules.RuleCoverageNodeBuilder;
import com.google.cloud.datastore.emulator.impl.storage.FirestoreEmulatorLookupHandler;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.firebase.firebear.client.JwtToken;
import com.google.firebase.rules.runtime.auth.RulesValidatedSecurityContext;
import com.google.firebase.rules.runtime.evaluators.RuleClient;
import com.google.firebase.rules.runtime.tracking.PermissionTrace;
import com.google.firebase.rules.runtime.tracking.RuleExpressionTracker;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.v1.Source;
import com.google.firestore.emulator.v1.ExpressionReport;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class EmulatorRulesAuthorizer {
    private static final DatastoreException METADATA_QUERY_REQUIRE_ADMIN_ERROR = DatastoreException.builder().errorCode(DatastoreV3Pb.Error.ErrorCode.PERMISSION_DENIED).message("Metadata operations require admin authentication.").build();
    private final FirestoreEmulatorConverters converters;
    private final RulesetAst rulesetAst;
    private final Source rules;
    private final RuleExpressionTracker<ExpressionReport> tracker = new RuleExpressionTracker<ExpressionReport>(RuleCoverageNodeBuilder.INSTANCE);
    private static final String DEFAULT_RELEASE_NAME = "DEFAULT_RELEASE_NAME";

    EmulatorRulesAuthorizer(RulesetAst rulesetAst, FirestoreEmulatorConverters converters, Source rules) {
        this.converters = converters;
        this.rulesetAst = rulesetAst;
        this.rules = rules;
    }

    public void checkCommit(FirestoreEmulatorRequestContext context, long transaction, Write write, LocalEntityStore.ReadView currentView, Map<EntityRef, Optional<Entity>> mutationResults) throws DatastoreException {
        if (write.mutations().isEmpty() || EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        JwtToken jwt = context.auth().map(EmulatorAuthorization::jwt).orElse(null);
        OnestoreEntity.Reference arbitraryKey = write.mutations().stream().map(Mutation::key).findAny().get();
        DatabaseRef dbRef = DatabaseRef.createForApp(arbitraryKey.getApp(), arbitraryKey.getDatabaseId());
        RulesRequestContext fakeRequestContext = EmulatorRulesAuthorizer.makeRulesContext(dbRef, context.requestTime(), transaction, jwt);
        this.withVerboseErrors(client -> {
            RulesAuthorizer.PerEntityWriteAuthorizer perEntityWriteAuthorizer = EmulatorRulesAuthorizer.rulesAuthorizer(client).checkCommit(fakeRequestContext, write);
            Map<EntityRef, OnestoreEntity.EntityProto> mutatedEntities = this.mangleMutations(mutationResults);
            FirestoreEmulatorLookupHandler lookupHandler = new FirestoreEmulatorLookupHandler(this.converters, currentView);
            for (EntityRef key : mutatedEntities.keySet()) {
                perEntityWriteAuthorizer.checkAccess(lookupHandler, lookupHandler.lookup(key), mutatedEntities.get(key), mutatedEntities);
            }
        });
    }

    public void checkLookup(FirestoreEmulatorRequestContext context, @Nullable Long transaction, ImmutableSet<OnestoreEntity.Reference> keysToLookup, LocalEntityStore.ReadView currentView) throws DatastoreException {
        if (keysToLookup.isEmpty() || EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        JwtToken jwt = context.auth().map(EmulatorAuthorization::jwt).orElse(null);
        OnestoreEntity.Reference arbitraryKey = (OnestoreEntity.Reference)keysToLookup.stream().findAny().get();
        DatabaseRef dbRef = DatabaseRef.createForApp(arbitraryKey.getApp(), arbitraryKey.getDatabaseId());
        RulesRequestContext fakeRequestContext = EmulatorRulesAuthorizer.makeRulesContext(dbRef, context.requestTime(), transaction, jwt);
        this.withVerboseErrors(client -> {
            RulesAuthorizer.PerEntityReadAuthorizer perEntityReadAuthorizer = EmulatorRulesAuthorizer.rulesAuthorizer(client).checkAccess(fakeRequestContext, Lookup.builder().keys(keysToLookup).build());
            FirestoreEmulatorLookupHandler lookupHandler = new FirestoreEmulatorLookupHandler(this.converters, currentView);
            for (OnestoreEntity.Reference key : keysToLookup) {
                EntityRef ref = FirestoreEmulatorConverters.toEntityRef(key);
                perEntityReadAuthorizer.checkAccess(lookupHandler, lookupHandler.lookup(ref));
            }
        });
    }

    public void checkQuery(FirestoreEmulatorRequestContext context, Query query, LocalEntityStore.ReadView currentView) throws DatastoreException {
        if (EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        JwtToken jwt = context.auth().map(EmulatorAuthorization::jwt).orElse(null);
        RulesRequestContext fakeRequestContext = EmulatorRulesAuthorizer.makeRulesContext(context.databaseRef(), context.requestTime(), null, jwt);
        FirestoreEmulatorLookupHandler lookupHandler = new FirestoreEmulatorLookupHandler(this.converters, currentView);
        this.withVerboseErrors(client -> EmulatorRulesAuthorizer.rulesAuthorizer(client).checkAccess(fakeRequestContext, this.converters.toDisjunctiveNormalForm(query), lookupHandler));
    }

    private Map<EntityRef, OnestoreEntity.EntityProto> mangleMutations(Map<EntityRef, Optional<Entity>> mutationResults) {
        HashMap<EntityRef, OnestoreEntity.EntityProto> mangled = new HashMap<EntityRef, OnestoreEntity.EntityProto>();
        for (Map.Entry<EntityRef, Optional<Entity>> entry : mutationResults.entrySet()) {
            OnestoreEntity.EntityProto value = entry.getValue().map(this.converters::entityToProto).orElse(null);
            mangled.put(entry.getKey(), value);
        }
        return mangled;
    }

    public void checkMetadataOperation(FirestoreEmulatorRequestContext context) throws DatastoreException {
        if (EmulatorRulesAuthorizer.isAdmin(context.auth())) {
            return;
        }
        throw METADATA_QUERY_REQUIRE_ADMIN_ERROR;
    }

    private static boolean isAdmin(Optional<EmulatorAuthorization> auth) {
        return auth.isPresent() && auth.get().kind().equals((Object)EmulatorAuthorization.Kind.ADMIN);
    }

    private static RulesRequestContext makeRulesContext(DatabaseRef dbRef, Instant timestamp, @Nullable Long transaction, @Nullable JwtToken jwt) {
        return RulesRequestContext.builder().alreadyAuthorized(false).databaseRef(dbRef).httpRequestHeaders(ImmutableMap.of()).rulesAccessCollector(new FakeRulesAccessCollector()).rulesValidatedSecurityContext(new RulesValidatedSecurityContext(null, jwt)).startTime(timestamp).stats(new EmulatorRulesStats()).transactionHandle(transaction).build();
    }

    private static RulesAuthorizer rulesAuthorizer(RuleClient ruleClient) {
        return new SinglePhaseRulesAuthorizer(FirebaseRulesAuthorizerOptions.builder().build(), ruleClient, Ticker.systemTicker(), new EntityToExpressionValueConverter(), DEFAULT_RELEASE_NAME){

            @Override
            protected DatastoreRuleContextBuilder makeRulesContext(RulesRequestContext requestContext) {
                DatastoreRuleContextBuilder builder = super.makeRulesContext(requestContext);
                builder.supplyFunction(DebugFunction.STDOUT);
                return builder;
            }
        };
    }

    private void withVerboseErrors(DatastoreConsumer<RuleClient> check) throws DatastoreException {
        EmulatorRuleClient client = new EmulatorRuleClient(this.rulesetAst);
        try {
            check.accept(client);
        }
        catch (DatastoreException e) {
            throw e.getErrorCode() != DatastoreV3Pb.Error.ErrorCode.PERMISSION_DENIED ? e : EmulatorRulesAuthorizer.verboseError(e, client.permissionTraces());
        }
        finally {
            this.tracker.addResultsFrom(client.permissionTraces());
        }
    }

    private static DatastoreException verboseError(DatastoreException cause, Collection<PermissionTrace> traces) {
        String statementsEvaluated = traces.stream().map(trace -> String.format("%s for '%s' @ L%d", trace.error().orElse("false"), trace.method(), trace.expression().getSourcePosition().getLine())).collect(Collectors.joining(", ", "\n", ""));
        String message = traces.isEmpty() ? "No matching allow statements" : statementsEvaluated;
        return DatastoreException.builder().errorCode(cause.getErrorCode()).message(message).cause(cause.getCause()).build();
    }

    public RuleCoverageReport ruleCoverageReport() {
        ImmutableCollection<ExpressionReport> children = this.tracker.expressionReports(this.rulesetAst);
        return RuleCoverageReport.newBuilder().setRules(this.rules).addAllReport(children).build();
    }

    private static final class EmulatorRulesStats
    extends GenericStats
    implements RulesStats {
        private final GenericStats.Stats<RulesStats.Summing, GenericStats.SummingStat> summingStats;
        private final GenericStats.Stats<RulesStats.Label, GenericStats.LabelStat> labelStats;
        private final GenericStats.Stats<RulesStats.Phase, GenericStats.DurationStat> phaseStats;

        EmulatorRulesStats() {
            super(GenericStats.CategoryTypeMismatchReporter.NOP);
            this.summingStats = this.register(RulesStats.Summing.class, this.summingBuilder);
            this.labelStats = this.register(RulesStats.Label.class, this.labelBuilder);
            this.phaseStats = this.register(RulesStats.Phase.class, this.durationBuilder(SYSTEM_TIMING));
        }

        @Override
        public GenericStats.SummingStat stat(RulesStats.Summing category) {
            return this.summingStats.stat(category);
        }

        @Override
        public GenericStats.LabelStat stat(RulesStats.Label category) {
            return this.labelStats.stat(category);
        }

        @Override
        public GenericStats.DurationStat stat(RulesStats.Phase category) {
            return this.phaseStats.stat(category);
        }
    }

    private static final class FakeRulesAccessCollector
    implements RulesAccessCollector {
        private FakeRulesAccessCollector() {
        }

        @Override
        public void registerLookup(LookupsToAuthorize.Lookup lookup) {
        }

        @Override
        public void registerLookup(LookupsToAuthorize.Lookup lookup, long durationInMicros, boolean success) {
        }

        @Override
        public void registerFieldAccesses(Collection<List<String>> fields) {
        }

        @Override
        public RulesAccessCollector setReleaseName(String name) {
            return this;
        }

        @Override
        public RulesAccessCollector setRulesetName(String name) {
            return this;
        }
    }
}

