/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.rules;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.emulator.impl.rules.AutoValue_EmulatorRulesCompiler_CompilerException;
import com.google.cloud.datastore.emulator.impl.rules.AutoValue_EmulatorRulesCompiler_EmulatorCompilationResult;
import com.google.cloud.datastore.emulator.impl.rules.EmulatorRulesAuthorizer;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.CompileResult;
import com.google.firebase.rules.lang.FirebaseRulesProtoCompiler;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.v1.Source;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class EmulatorRulesCompiler {
    private EmulatorRulesCompiler() {
    }

    public static EmulatorCompilationResult makeAuthorizer(Source rules, FirestoreEmulatorConverters converters) {
        CompileResult compileResult = FirebaseRulesProtoCompiler.create().compile(rules);
        if (compileResult.hasCompilationError()) {
            return EmulatorCompilationResult.forError(compileResult.getIssues());
        }
        return EmulatorCompilationResult.of(new EmulatorRulesAuthorizer(compileResult.getRulesetAst(), converters, rules), compileResult.getIssues());
    }

    @AutoValue
    public static abstract class CompilerException
    extends IllegalArgumentException {
        public abstract ImmutableList<Issue> issues();

        public static CompilerException of(Iterable<Issue> issues) {
            return new AutoValue_EmulatorRulesCompiler_CompilerException(ImmutableList.copyOf(issues));
        }

        public DatastoreException asDatastoreException() {
            String message = this.issues().stream().map(err -> String.format("L%d:%d %s", err.getSourcePosition().getLine(), err.getSourcePosition().getColumn(), err.getDescription())).collect(Collectors.joining("\n"));
            String string = String.valueOf(message);
            return new DatastoreException(string.length() != 0 ? "Error compiling rules:\n".concat(string) : new String("Error compiling rules:\n"), DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, this);
        }
    }

    @AutoValue
    public static abstract class EmulatorCompilationResult {
        @Nullable
        abstract EmulatorRulesAuthorizer authorizer();

        public abstract ImmutableList<Issue> issues();

        public final EmulatorRulesAuthorizer getAuthorizer() throws DatastoreException {
            this.checkCompilationSucceeded();
            return this.authorizer();
        }

        public final void checkCompilationSucceeded() throws DatastoreException {
            if (this.authorizer() == null) {
                throw CompilerException.of(this.issues()).asDatastoreException();
            }
        }

        static EmulatorCompilationResult of(EmulatorRulesAuthorizer authorizer, List<Issue> issues) {
            return new AutoValue_EmulatorRulesCompiler_EmulatorCompilationResult(authorizer, ImmutableList.copyOf(issues));
        }

        static EmulatorCompilationResult forError(List<Issue> issues) {
            return new AutoValue_EmulatorRulesCompiler_EmulatorCompilationResult(null, ImmutableList.copyOf(issues));
        }
    }
}

