/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.storage;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.storage.StoredEntity;
import com.google.cloud.datastore.emulator.impl.transactions.LockType;
import com.google.cloud.datastore.emulator.impl.transactions.PessimisticLockManager;
import com.google.cloud.datastore.emulator.impl.util.EmulatorComparators;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public final class FlatLocalEntityStore
extends LocalEntityStore {
    private final ConcurrentMap<EntityRef, StoredEntity.History> rows = Maps.newConcurrentMap();
    private final PessimisticLockManager<EntityRef> lockManager;
    private final TimeSource clock;
    private final Duration historyThreshold;

    public FlatLocalEntityStore(TimeSource clock, Duration historyThreshold) {
        this.clock = clock;
        this.historyThreshold = historyThreshold;
        this.lockManager = PessimisticLockManager.create(EmulatorComparators.ENTITY_REF_COMPARATOR, clock);
    }

    @Override
    public LocalEntityStore.ReadView snapshot(Instant time) {
        return new HistoricalSnapshotReadView(time);
    }

    @Override
    public synchronized LocalEntityStore.ReadView read(long transaction) {
        return new StronglyConsistentReadView(transaction);
    }

    @Override
    public synchronized LocalEntityStore.ReadWriteView readWrite(long transaction, ImmutableSet<EntityRef> writeHint) {
        return new StronglyConsistentReadWriteView(transaction, writeHint);
    }

    private EntityReadResult updateRow(EntityRef ref, Optional<Entity> entityToPut, Instant now) {
        StoredEntity.History history = this.historyFor(ref);
        StoredEntity cur = history.latest();
        if (!cur.entity().equals(entityToPut)) {
            cur = cur.updated(entityToPut, now);
            this.rows.put(ref, history.withNewState(cur));
        }
        return EntityReadResult.builder().ref(ref).entity(cur.entity()).createdAt(cur.createdAt()).updatedAt(cur.updatedAt()).readAt(now).build();
    }

    private StoredEntity.History historyFor(EntityRef ref) {
        return this.rows.computeIfAbsent(ref, x -> new StoredEntity.History(this.historyThreshold));
    }

    private final class HistoricalSnapshotReadView
    implements LocalEntityStore.ReadView {
        private final Instant timestamp;

        HistoricalSnapshotReadView(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> get(Set<EntityRef> keys) {
            return keys.stream().collect(ImmutableMap.toImmutableMap(key -> key, key -> {
                StoredEntity row = FlatLocalEntityStore.this.historyFor(key).atInstant(this.timestamp);
                return EntityReadResult.builder().ref((EntityRef)key).entity(row.entity()).createdAt(row.createdAt()).updatedAt(row.commitTimestamp()).readAt(this.timestamp).build();
            }));
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> all() {
            return FlatLocalEntityStore.this.rows.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
                StoredEntity row = ((StoredEntity.History)entry.getValue()).atInstant(this.timestamp);
                return EntityReadResult.builder().ref((EntityRef)entry.getKey()).entity(row.entity()).createdAt(row.createdAt()).updatedAt(row.commitTimestamp()).readAt(this.timestamp).build();
            }));
        }

        @Override
        public void close() {
        }
    }

    private final class StronglyConsistentReadWriteView
    extends StronglyConsistentReadView
    implements LocalEntityStore.ReadWriteView {
        private final ImmutableSet<EntityRef> writeHints;

        StronglyConsistentReadWriteView(long transaction, ImmutableSet<EntityRef> writeHints) {
            super((PessimisticLockManager.PessimisticTransactionEvidence)FlatLocalEntityStore.this.lockManager.lockForCommit(transaction, writeHints));
            this.writeHints = writeHints;
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> commit(ImmutableMap<EntityRef, Optional<Entity>> entitiesToPut) {
            Preconditions.checkArgument(this.writeHints.containsAll(entitiesToPut.keySet()));
            Instant now = FlatLocalEntityStore.this.clock.now();
            return entitiesToPut.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> FlatLocalEntityStore.this.updateRow((EntityRef)entry.getKey(), (Optional)entry.getValue(), now)));
        }
    }

    private class StronglyConsistentReadView
    implements LocalEntityStore.ReadView {
        private final PessimisticLockManager.PessimisticTransactionEvidence evidence;

        private StronglyConsistentReadView(PessimisticLockManager.PessimisticTransactionEvidence evidence) {
            this.evidence = evidence;
        }

        StronglyConsistentReadView(long transaction) {
            this((PessimisticLockManager.PessimisticTransactionEvidence)flatLocalEntityStore.lockManager.lockForReads(transaction, ImmutableSet.of()));
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> get(Set<EntityRef> keys) {
            FlatLocalEntityStore.this.lockManager.acquireAdditionalLocks(this.evidence, ImmutableSet.copyOf(keys), LockType.READ);
            Instant now = FlatLocalEntityStore.this.clock.now();
            return keys.stream().collect(ImmutableMap.toImmutableMap(key -> key, key -> {
                StoredEntity row = FlatLocalEntityStore.this.historyFor(key).latest();
                return EntityReadResult.builder().ref((EntityRef)key).entity(row.entity()).createdAt(row.createdAt()).updatedAt(row.commitTimestamp()).readAt(now).build();
            }));
        }

        @Override
        public ImmutableMap<EntityRef, EntityReadResult> all() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.evidence.close();
        }
    }
}

