/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.storage;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.context.NonThrowingAutoCloseable;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;

public abstract class LocalEntityStore {
    public abstract ReadView snapshot(Instant var1);

    public abstract ReadView read(long var1);

    public abstract ReadWriteView readWrite(long var1, ImmutableSet<EntityRef> var3);

    public final ImmutableMap<EntityRef, EntityReadResult> commit(long transaction, ImmutableMap<EntityRef, Optional<Entity>> entitiesToPut) {
        try (ReadWriteView rw = this.readWrite(transaction, (ImmutableSet<EntityRef>)entitiesToPut.keySet());){
            ImmutableMap<EntityRef, EntityReadResult> immutableMap = rw.commit(entitiesToPut);
            return immutableMap;
        }
    }

    public static interface ReadWriteView
    extends ReadView {
        public ImmutableMap<EntityRef, EntityReadResult> commit(ImmutableMap<EntityRef, Optional<Entity>> var1);
    }

    public static interface ReadView
    extends NonThrowingAutoCloseable {
        public ImmutableMap<EntityRef, EntityReadResult> get(Set<EntityRef> var1);

        public ImmutableMap<EntityRef, EntityReadResult> all();
    }
}

