/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.transactions;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.cloud.datastore.emulator.impl.transactions.AutoValue_EmulatorTransactionManager_ReadOnlyTransaction;
import com.google.cloud.datastore.emulator.impl.transactions.AutoValue_EmulatorTransactionManager_ReadWriteTransaction;
import com.google.common.base.Preconditions;
import com.google.common.time.TimeSource;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.TransactionOptions;
import com.google.protobuf.util.JavaTimeConversions;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class EmulatorTransactionManager {
    private final AtomicLong counter = new AtomicLong();
    private final ConcurrentMap<Long, EmulatorTransaction> transactions = new ConcurrentHashMap<Long, EmulatorTransaction>();
    private final Duration transactionTimeout;
    private final TimeSource timeSource;

    public EmulatorTransactionManager(TimeSource timeSource, Duration transactionTimeout) {
        this.timeSource = timeSource;
        this.transactionTimeout = transactionTimeout;
    }

    public ReadWriteTransaction nextReadWrite() {
        ReadWriteTransaction transactionHandle = ReadWriteTransaction.create(this.timeSource.now(), this.nextTransactionHandle());
        this.transactions.put(transactionHandle.handle(), transactionHandle);
        return transactionHandle;
    }

    public EmulatorTransaction create(GetDocumentRequest request) throws DatastoreException {
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: {
                return this.snapshotRead();
            }
            case TRANSACTION: {
                return this.reuseExisting(Transactions.getTransactionHandle(request.getTransaction()));
            }
            case READ_TIME: {
                return this.snapshotRead(JavaTimeConversions.toJavaInstant(request.getReadTime()));
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public EmulatorTransaction create(ListDocumentsRequest request) throws DatastoreException {
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: {
                return this.snapshotRead();
            }
            case TRANSACTION: {
                return this.reuseExisting(Transactions.getTransactionHandle(request.getTransaction()));
            }
            case READ_TIME: {
                return this.snapshotRead(JavaTimeConversions.toJavaInstant(request.getReadTime()));
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public EmulatorTransaction create(BatchGetDocumentsRequest request) throws DatastoreException {
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: {
                return this.snapshotRead();
            }
            case NEW_TRANSACTION: {
                return this.create(request.getNewTransaction());
            }
            case TRANSACTION: {
                return this.reuseExisting(Transactions.getTransactionHandle(request.getTransaction()));
            }
            case READ_TIME: {
                return this.snapshotRead(JavaTimeConversions.toJavaInstant(request.getReadTime()));
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public ReadWriteTransaction create(CommitRequest request) throws DatastoreException {
        if (request.getTransaction().isEmpty()) {
            return this.nextReadWrite();
        }
        EmulatorTransaction existingTransaction = this.reuseExisting(Transactions.getTransactionHandle(request.getTransaction()));
        return existingTransaction.fold(readOnlyTransaction -> {
            throw DatastoreExceptionHelper.badRequest("Cannot modify entities in a read-only transaction.", new Object[0]);
        }, readWriteTransaction -> readWriteTransaction);
    }

    public EmulatorTransaction create(RunQueryRequest request) throws DatastoreException {
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: {
                return this.snapshotRead();
            }
            case NEW_TRANSACTION: {
                return this.create(request.getNewTransaction());
            }
            case TRANSACTION: {
                return this.reuseExisting(Transactions.getTransactionHandle(request.getTransaction()));
            }
            case READ_TIME: {
                return this.snapshotRead(JavaTimeConversions.toJavaInstant(request.getReadTime()));
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public EmulatorTransaction create(TransactionOptions options) {
        switch (options.getModeCase()) {
            case READ_ONLY: {
                return this.nextReadOnly();
            }
            case MODE_NOT_SET: 
            case READ_WRITE: {
                return this.nextReadWrite();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private long nextTransactionHandle() {
        return this.counter.incrementAndGet();
    }

    private ReadOnlyTransaction nextReadOnly() {
        ReadOnlyTransaction transactionHandle = ReadOnlyTransaction.create(this.timeSource.now(), this.nextTransactionHandle());
        this.transactions.put(transactionHandle.handle(), transactionHandle);
        return transactionHandle;
    }

    private EmulatorTransaction reuseExisting(long handle) {
        EmulatorTransaction txn = (EmulatorTransaction)this.transactions.get(handle);
        Preconditions.checkState(txn != null && txn.creationTime().plus(this.transactionTimeout).isAfter(this.timeSource.now()));
        return txn;
    }

    private ReadOnlyTransaction snapshotRead(Instant readTime) {
        return ReadOnlyTransaction.create(readTime, this.nextTransactionHandle());
    }

    private ReadOnlyTransaction snapshotRead() {
        return this.snapshotRead(this.timeSource.now());
    }

    @AutoValue
    public static abstract class ReadWriteTransaction
    implements EmulatorTransaction {
        static ReadWriteTransaction create(Instant creationTime, long handle) {
            return new AutoValue_EmulatorTransactionManager_ReadWriteTransaction(creationTime, handle);
        }

        @Override
        public <R> R fold(DatastoreFunction<ReadOnlyTransaction, R> ifReadOnly, DatastoreFunction<ReadWriteTransaction, R> ifReadWrite) throws DatastoreException {
            return ifReadWrite.apply(this);
        }
    }

    @AutoValue
    public static abstract class ReadOnlyTransaction
    implements EmulatorTransaction {
        static ReadOnlyTransaction create(Instant creationTime, long handle) {
            return new AutoValue_EmulatorTransactionManager_ReadOnlyTransaction(creationTime, handle);
        }

        public final Instant snapshotReadTime() {
            return this.creationTime();
        }

        @Override
        public final <R> R fold(DatastoreFunction<ReadOnlyTransaction, R> ifReadOnly, DatastoreFunction<ReadWriteTransaction, R> ifReadWrite) throws DatastoreException {
            return ifReadOnly.apply(this);
        }
    }

    @FunctionalInterface
    public static interface DatastoreFunction<T, R> {
        public R apply(T var1) throws DatastoreException;
    }

    public static interface EmulatorTransaction {
        public Instant creationTime();

        public long handle();

        public <R> R fold(DatastoreFunction<ReadOnlyTransaction, R> var1, DatastoreFunction<ReadWriteTransaction, R> var2) throws DatastoreException;
    }
}

