/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.transactions;

import com.google.cloud.datastore.emulator.impl.transactions.EntityLock;
import com.google.cloud.datastore.emulator.impl.transactions.LockManager;
import com.google.cloud.datastore.emulator.impl.transactions.LockType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.time.TimeSource;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PessimisticLockManager<K>
implements LockManager<K> {
    static final Duration DEFAULT_ACQUIRE_TIMEOUT = Duration.ofSeconds(30L);
    static final Duration DEFAULT_PROCESSING_INTERVAL = Duration.ofMillis(10L);
    private static final Duration DEFAULT_OWNERSHIP_TIMEOUT = Duration.ofSeconds(30L);
    private final ConcurrentMap<Long, ConcurrentMap<K, LockType>> txnToUsage = new ConcurrentHashMap<Long, ConcurrentMap<K, LockType>>();
    private final Map<K, EntityLock> locks = new ConcurrentHashMap<K, EntityLock>();
    private final Comparator<K> keyComparator;
    private final TimeSource timeSource;
    private final Duration acquireTimeout;

    public static <K extends Comparable<K>> PessimisticLockManager<K> create(TimeSource timeSource) {
        return PessimisticLockManager.create(timeSource, DEFAULT_ACQUIRE_TIMEOUT);
    }

    public static <K extends Comparable<K>> PessimisticLockManager<K> create(TimeSource timeSource, Duration acquireTimeout) {
        return new PessimisticLockManager(Comparator.naturalOrder(), timeSource, acquireTimeout, DEFAULT_PROCESSING_INTERVAL);
    }

    public static <K extends Comparable<K>> PessimisticLockManager<K> create(TimeSource timeSource, Duration acquireTimeout, Duration lockProcessingInterval) {
        return new PessimisticLockManager(Comparator.naturalOrder(), timeSource, acquireTimeout, lockProcessingInterval);
    }

    public static <K> PessimisticLockManager<K> create(Comparator<K> comparator, TimeSource timeSource) {
        return new PessimisticLockManager<K>(comparator, timeSource, DEFAULT_ACQUIRE_TIMEOUT, DEFAULT_PROCESSING_INTERVAL);
    }

    private PessimisticLockManager(Comparator<K> keyComparator, TimeSource timeSource, Duration acquireTimeout, Duration lockProcessingInterval) {
        this.keyComparator = keyComparator;
        this.timeSource = timeSource;
        this.acquireTimeout = acquireTimeout;
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (EntityLock lock : PessimisticLockManager.this.locks.values()) {
                    lock.processLockRequests();
                }
            }
        }, 0L, lockProcessingInterval.toMillis());
    }

    private NavigableMap<K, LockType> getAllKeysForTransaction(LockType lockType, long transactionHandle, ImmutableSet<K> additionalKeys) {
        ConcurrentMap allKeys = this.txnToUsage.computeIfAbsent(transactionHandle, handle -> new ConcurrentHashMap());
        additionalKeys.forEach(key -> {
            LockType origLockType = (LockType)allKeys.get(key);
            if (origLockType == null || origLockType == LockType.READ && lockType == LockType.COMMIT) {
                allKeys.put(key, lockType);
            }
        });
        return ImmutableSortedMap.copyOf(allKeys, this.keyComparator);
    }

    public void acquireAdditionalLocks(PessimisticTransactionEvidence ev, ImmutableSet<K> additionalKeys, LockType lockType) {
        Preconditions.checkArgument(lockType.compareTo(ev.lockType) <= 0);
        Duration totalTimeSpent = Duration.ZERO;
        for (Map.Entry entry : this.getAllKeysForTransaction(lockType, ev.transactionHandle, additionalKeys).entrySet()) {
            EntityLock lock = this.locks.computeIfAbsent(entry.getKey(), k -> new EntityLock(DEFAULT_OWNERSHIP_TIMEOUT, this.timeSource));
            ev.addLock(lock);
            try {
                Instant startTime = this.timeSource.now();
                lock.acquireOwnership((LockType)entry.getValue(), ev.transactionHandle).get(this.acquireTimeout.minus(totalTimeSpent).toMillis(), TimeUnit.MILLISECONDS).lock();
                totalTimeSpent = totalTimeSpent.plus(Duration.between(this.timeSource.now(), startTime));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ev.releaseAll();
                throw new LockManager.TransactionExpiredException();
            }
        }
    }

    @Override
    public PessimisticTransactionEvidence lockForReads(long transactionHandle, ImmutableSet<K> additionalKeys) {
        PessimisticTransactionEvidence ev = new PessimisticTransactionEvidence(transactionHandle, LockType.READ);
        this.acquireAdditionalLocks(ev, additionalKeys, LockType.READ);
        return ev;
    }

    @Override
    public PessimisticTransactionEvidence lockForCommit(long transactionHandle, ImmutableSet<K> additionalKeys) {
        PessimisticTransactionEvidence ev = new PessimisticTransactionEvidence(transactionHandle, LockType.COMMIT);
        this.acquireAdditionalLocks(ev, additionalKeys, LockType.COMMIT);
        return ev;
    }

    @VisibleForTesting
    Map<K, EntityLock> getLocks() {
        return this.locks;
    }

    public static final class PessimisticTransactionEvidence
    implements LockManager.TransactionEvidence {
        private final long transactionHandle;
        private final LockType lockType;
        private final Set<EntityLock> locksAcquired = new HashSet<EntityLock>();

        PessimisticTransactionEvidence(long transactionHandle, LockType lockType) {
            this.transactionHandle = transactionHandle;
            this.lockType = lockType;
        }

        void addLock(EntityLock lock) {
            this.locksAcquired.add(lock);
        }

        void releaseAll() {
            for (EntityLock lock : this.locksAcquired) {
                lock.releaseLock(this.transactionHandle);
            }
        }

        @Override
        public void close() {
            for (EntityLock lock : this.locksAcquired) {
                switch (this.lockType) {
                    case READ: {
                        lock.unlockLock(LockType.READ, this.transactionHandle);
                        break;
                    }
                    case COMMIT: {
                        lock.releaseLock(this.transactionHandle);
                    }
                }
            }
        }
    }
}

