/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import io.grpc.stub.StreamObserver;
import java.util.function.Function;

public class ConvertingStreamObserver<S, T>
implements StreamObserver<S> {
    private final StreamObserver<T> underlying;
    private final Function<S, T> converter;

    public ConvertingStreamObserver(StreamObserver<T> underlying, Function<S, T> converter) {
        this.underlying = underlying;
        this.converter = converter;
    }

    @Override
    public void onNext(S value) {
        this.underlying.onNext(this.converter.apply(value));
    }

    @Override
    public void onError(Throwable t) {
        this.underlying.onError(t);
    }

    @Override
    public void onCompleted() {
        this.underlying.onCompleted();
    }
}

