/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.util;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.emulator.impl.proto.ListCollectionIdsPageToken;
import com.google.cloud.datastore.emulator.impl.proto.ListDocumentsPageToken;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Random;

public final class EmulatorPageTokens {
    private static final Random prng = new Random();
    private static final int NONCE_LENGTH = 8;

    private EmulatorPageTokens() {
    }

    private static ByteString randomNonce() {
        byte[] arr = new byte[8];
        prng.nextBytes(arr);
        return ByteString.copyFrom(arr);
    }

    public static final class ListCollectionIds {
        public static String serialize(ListCollectionIdsPageToken pageToken) {
            return BaseEncoding.base64().encode(pageToken.toByteArray());
        }

        public static ListCollectionIdsPageToken deserialize(String raw) throws InvalidConversionException {
            try {
                return ListCollectionIdsPageToken.parseFrom(BaseEncoding.base64().decode(raw));
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException("invalid page token", e);
            }
        }

        public static ListCollectionIdsPageToken create(String collectionId) {
            return ListCollectionIdsPageToken.newBuilder().setCollectionId(collectionId).setNonce(EmulatorPageTokens.randomNonce()).build();
        }
    }

    public static final class ListDocuments {
        public static String serialize(ListDocumentsPageToken pageToken) {
            return BaseEncoding.base64().encode(pageToken.toByteArray());
        }

        public static ListDocumentsPageToken deserialize(String raw) throws InvalidConversionException {
            try {
                return ListDocumentsPageToken.parseFrom(BaseEncoding.base64().decode(raw));
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException("invalid page token", e);
            }
        }

        public static ListDocumentsPageToken create(String documentName) {
            return ListDocumentsPageToken.newBuilder().setDocumentName(documentName).setNonce(EmulatorPageTokens.randomNonce()).build();
        }
    }
}

