/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.internal;

import com.google.cloud.datastore.internal.DatastoreInternalProto;
import com.google.cloud.datastore.internal.TransactionOrBuilder;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Transaction
extends GeneratedMessage
implements TransactionOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int HANDLE_FIELD_NUMBER = 2;
    private long handle_;
    public static final int RAW_BACKEND_ADDRESS_FIELD_NUMBER = 6;
    private List<ByteString> rawBackendAddress_;
    public static final int BACKEND_PORT_FIELD_NUMBER = 5;
    private int backendPort_;
    public static final int V4_ENCRYPTED_SERVER_ADDRESS_OBSOLETE_FIELD_NUMBER = 3;
    private ByteString v4EncryptedServerAddressObsolete_;
    public static final int ENCRYPTED_PROTECTED_DATA_FIELD_NUMBER = 4;
    private ByteString encryptedProtectedData_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Transaction DEFAULT_INSTANCE = new Transaction();
    private static final Parser<Transaction> PARSER = new AbstractParser<Transaction>(){

        @Override
        public Transaction parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new Transaction(input, extensionRegistry);
        }
    };

    private Transaction(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private Transaction() {
        this.rawBackendAddress_ = Collections.emptyList();
        this.v4EncryptedServerAddressObsolete_ = ByteString.EMPTY;
        this.encryptedProtectedData_ = ByteString.EMPTY;
    }

    @Override
    protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
        return new Transaction();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private Transaction(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block14: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block14;
                    }
                    case 17: {
                        this.handle_ = input.readFixed64();
                        continue block14;
                    }
                    case 26: {
                        this.v4EncryptedServerAddressObsolete_ = input.readBytes();
                        continue block14;
                    }
                    case 34: {
                        this.encryptedProtectedData_ = input.readBytes();
                        continue block14;
                    }
                    case 40: {
                        this.backendPort_ = input.readInt32();
                        continue block14;
                    }
                    case 50: {
                        if (!(mutable_bitField0_ & true)) {
                            this.rawBackendAddress_ = new ArrayList<ByteString>();
                            mutable_bitField0_ |= true;
                        }
                        this.rawBackendAddress_.add(input.readBytes());
                        continue block14;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.rawBackendAddress_ = Collections.unmodifiableList(this.rawBackendAddress_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_descriptor;
    }

    @Override
    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_fieldAccessorTable.ensureFieldAccessorsInitialized(Transaction.class, Builder.class);
    }

    @Override
    public long getHandle() {
        return this.handle_;
    }

    @Override
    public List<ByteString> getRawBackendAddressList() {
        return this.rawBackendAddress_;
    }

    @Override
    public int getRawBackendAddressCount() {
        return this.rawBackendAddress_.size();
    }

    @Override
    public ByteString getRawBackendAddress(int index) {
        return this.rawBackendAddress_.get(index);
    }

    @Override
    public int getBackendPort() {
        return this.backendPort_;
    }

    @Override
    public ByteString getV4EncryptedServerAddressObsolete() {
        return this.v4EncryptedServerAddressObsolete_;
    }

    @Override
    public ByteString getEncryptedProtectedData() {
        return this.encryptedProtectedData_;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.handle_ != 0L) {
            output.writeFixed64(2, this.handle_);
        }
        if (!this.v4EncryptedServerAddressObsolete_.isEmpty()) {
            output.writeBytes(3, this.v4EncryptedServerAddressObsolete_);
        }
        if (!this.encryptedProtectedData_.isEmpty()) {
            output.writeBytes(4, this.encryptedProtectedData_);
        }
        if (this.backendPort_ != 0) {
            output.writeInt32(5, this.backendPort_);
        }
        for (int i = 0; i < this.rawBackendAddress_.size(); ++i) {
            output.writeBytes(6, this.rawBackendAddress_.get(i));
        }
        this.unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.handle_ != 0L) {
            size += CodedOutputStream.computeFixed64Size(2, this.handle_);
        }
        if (!this.v4EncryptedServerAddressObsolete_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(3, this.v4EncryptedServerAddressObsolete_);
        }
        if (!this.encryptedProtectedData_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(4, this.encryptedProtectedData_);
        }
        if (this.backendPort_ != 0) {
            size += CodedOutputStream.computeInt32Size(5, this.backendPort_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.rawBackendAddress_.size(); ++i) {
            dataSize += CodedOutputStream.computeBytesSizeNoTag(this.rawBackendAddress_.get(i));
        }
        size += dataSize;
        size += 1 * this.getRawBackendAddressList().size();
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Transaction)) {
            return super.equals(obj);
        }
        Transaction other = (Transaction)obj;
        if (this.getHandle() != other.getHandle()) {
            return false;
        }
        if (!this.getRawBackendAddressList().equals(other.getRawBackendAddressList())) {
            return false;
        }
        if (this.getBackendPort() != other.getBackendPort()) {
            return false;
        }
        if (!this.getV4EncryptedServerAddressObsolete().equals(other.getV4EncryptedServerAddressObsolete())) {
            return false;
        }
        if (!this.getEncryptedProtectedData().equals(other.getEncryptedProtectedData())) {
            return false;
        }
        return this.unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Transaction.getDescriptor().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + Internal.hashLong(this.getHandle());
        if (this.getRawBackendAddressCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getRawBackendAddressList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getBackendPort();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getV4EncryptedServerAddressObsolete().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getEncryptedProtectedData().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    @Override
    protected MutableMessage internalMutableDefault() {
        return MutableDefaultLoader.get();
    }

    public static Transaction parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Transaction parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Transaction parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Transaction parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Transaction parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Transaction parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Transaction parseFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static Transaction parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static Transaction parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static Transaction parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static Transaction parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static Transaction parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return Transaction.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Transaction prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Transaction getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Transaction> parser() {
        return PARSER;
    }

    public Parser<Transaction> getParserForType() {
        return PARSER;
    }

    @Override
    public Transaction getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements TransactionOrBuilder {
        private int bitField0_;
        private long handle_;
        private List<ByteString> rawBackendAddress_ = Collections.emptyList();
        private int backendPort_;
        private ByteString v4EncryptedServerAddressObsolete_ = ByteString.EMPTY;
        private ByteString encryptedProtectedData_ = ByteString.EMPTY;

        public static final Descriptors.Descriptor getDescriptor() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_fieldAccessorTable.ensureFieldAccessorsInitialized(Transaction.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.handle_ = 0L;
            this.rawBackendAddress_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.backendPort_ = 0;
            this.v4EncryptedServerAddressObsolete_ = ByteString.EMPTY;
            this.encryptedProtectedData_ = ByteString.EMPTY;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_descriptor;
        }

        @Override
        public Transaction getDefaultInstanceForType() {
            return Transaction.getDefaultInstance();
        }

        @Override
        public Transaction build() {
            Transaction result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public Transaction buildPartial() {
            Transaction result = new Transaction(this);
            int from_bitField0_ = this.bitField0_;
            result.handle_ = this.handle_;
            if ((this.bitField0_ & 1) != 0) {
                this.rawBackendAddress_ = Collections.unmodifiableList(this.rawBackendAddress_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.rawBackendAddress_ = this.rawBackendAddress_;
            result.backendPort_ = this.backendPort_;
            result.v4EncryptedServerAddressObsolete_ = this.v4EncryptedServerAddressObsolete_;
            result.encryptedProtectedData_ = this.encryptedProtectedData_;
            this.onBuilt();
            return result;
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof Transaction) {
                return this.mergeFrom((Transaction)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Transaction other) {
            if (other == Transaction.getDefaultInstance()) {
                return this;
            }
            if (other.getHandle() != 0L) {
                this.setHandle(other.getHandle());
            }
            if (!other.rawBackendAddress_.isEmpty()) {
                if (this.rawBackendAddress_.isEmpty()) {
                    this.rawBackendAddress_ = other.rawBackendAddress_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureRawBackendAddressIsMutable();
                    this.rawBackendAddress_.addAll(other.rawBackendAddress_);
                }
                this.onChanged();
            }
            if (other.getBackendPort() != 0) {
                this.setBackendPort(other.getBackendPort());
            }
            if (other.getV4EncryptedServerAddressObsolete() != ByteString.EMPTY) {
                this.setV4EncryptedServerAddressObsolete(other.getV4EncryptedServerAddressObsolete());
            }
            if (other.getEncryptedProtectedData() != ByteString.EMPTY) {
                this.setEncryptedProtectedData(other.getEncryptedProtectedData());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            Transaction parsedMessage = null;
            try {
                parsedMessage = (Transaction)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (Transaction)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public long getHandle() {
            return this.handle_;
        }

        public Builder setHandle(long value) {
            this.handle_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearHandle() {
            this.handle_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureRawBackendAddressIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.rawBackendAddress_ = new ArrayList<ByteString>(this.rawBackendAddress_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<ByteString> getRawBackendAddressList() {
            return (this.bitField0_ & 1) != 0 ? Collections.unmodifiableList(this.rawBackendAddress_) : this.rawBackendAddress_;
        }

        @Override
        public int getRawBackendAddressCount() {
            return this.rawBackendAddress_.size();
        }

        @Override
        public ByteString getRawBackendAddress(int index) {
            return this.rawBackendAddress_.get(index);
        }

        public Builder setRawBackendAddress(int index, ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRawBackendAddressIsMutable();
            this.rawBackendAddress_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRawBackendAddress(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRawBackendAddressIsMutable();
            this.rawBackendAddress_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRawBackendAddress(Iterable<? extends ByteString> values) {
            this.ensureRawBackendAddressIsMutable();
            AbstractMessageLite.Builder.addAll(values, this.rawBackendAddress_);
            this.onChanged();
            return this;
        }

        public Builder clearRawBackendAddress() {
            this.rawBackendAddress_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public int getBackendPort() {
            return this.backendPort_;
        }

        public Builder setBackendPort(int value) {
            this.backendPort_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBackendPort() {
            this.backendPort_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getV4EncryptedServerAddressObsolete() {
            return this.v4EncryptedServerAddressObsolete_;
        }

        public Builder setV4EncryptedServerAddressObsolete(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.v4EncryptedServerAddressObsolete_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearV4EncryptedServerAddressObsolete() {
            this.v4EncryptedServerAddressObsolete_ = Transaction.getDefaultInstance().getV4EncryptedServerAddressObsolete();
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getEncryptedProtectedData() {
            return this.encryptedProtectedData_;
        }

        public Builder setEncryptedProtectedData(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.encryptedProtectedData_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearEncryptedProtectedData() {
            this.encryptedProtectedData_ = Transaction.getDefaultInstance().getEncryptedProtectedData();
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }
    }

    private static final class MutableDefaultLoader {
        private static final Object defaultOrRuntimeException;

        private MutableDefaultLoader() {
        }

        public static MutableMessage get() {
            if (defaultOrRuntimeException instanceof RuntimeException) {
                throw (RuntimeException)defaultOrRuntimeException;
            }
            return (MutableMessage)defaultOrRuntimeException;
        }

        static {
            Object local;
            try {
                local = Transaction.internalMutableDefault("com.google.cloud.datastore.internal.proto1api.Transaction");
            }
            catch (RuntimeException e) {
                local = e;
            }
            defaultOrRuntimeException = local;
        }
    }

    public static final class ProtectedData
    extends GeneratedMessage
    implements ProtectedDataOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int RAW_BACKEND_ADDRESS_FIELD_NUMBER = 6;
        private List<ByteString> rawBackendAddress_;
        public static final int BACKEND_PORT_FIELD_NUMBER = 5;
        private int backendPort_;
        public static final int HANDLE_FIELD_NUMBER = 2;
        private long handle_;
        public static final int CREATION_TIME_USEC_FIELD_NUMBER = 3;
        private long creationTimeUsec_;
        public static final int PROJECT_NUMBER_FIELD_NUMBER = 4;
        private long projectNumber_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ProtectedData DEFAULT_INSTANCE = new ProtectedData();
        private static final Parser<ProtectedData> PARSER = new AbstractParser<ProtectedData>(){

            @Override
            public ProtectedData parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new ProtectedData(input, extensionRegistry);
            }
        };

        private ProtectedData(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private ProtectedData() {
            this.rawBackendAddress_ = Collections.emptyList();
        }

        @Override
        protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
            return new ProtectedData();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private ProtectedData(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            boolean mutable_bitField0_ = false;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block14: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block14;
                        }
                        case 17: {
                            this.handle_ = input.readFixed64();
                            continue block14;
                        }
                        case 24: {
                            this.creationTimeUsec_ = input.readInt64();
                            continue block14;
                        }
                        case 32: {
                            this.projectNumber_ = input.readInt64();
                            continue block14;
                        }
                        case 40: {
                            this.backendPort_ = input.readInt32();
                            continue block14;
                        }
                        case 50: {
                            if (!(mutable_bitField0_ & true)) {
                                this.rawBackendAddress_ = new ArrayList<ByteString>();
                                mutable_bitField0_ |= true;
                            }
                            this.rawBackendAddress_.add(input.readBytes());
                            continue block14;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
            }
            finally {
                if (mutable_bitField0_ & true) {
                    this.rawBackendAddress_ = Collections.unmodifiableList(this.rawBackendAddress_);
                }
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_ProtectedData_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_ProtectedData_fieldAccessorTable.ensureFieldAccessorsInitialized(ProtectedData.class, Builder.class);
        }

        @Override
        public List<ByteString> getRawBackendAddressList() {
            return this.rawBackendAddress_;
        }

        @Override
        public int getRawBackendAddressCount() {
            return this.rawBackendAddress_.size();
        }

        @Override
        public ByteString getRawBackendAddress(int index) {
            return this.rawBackendAddress_.get(index);
        }

        @Override
        public int getBackendPort() {
            return this.backendPort_;
        }

        @Override
        public long getHandle() {
            return this.handle_;
        }

        @Override
        public long getCreationTimeUsec() {
            return this.creationTimeUsec_;
        }

        @Override
        public long getProjectNumber() {
            return this.projectNumber_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.handle_ != 0L) {
                output.writeFixed64(2, this.handle_);
            }
            if (this.creationTimeUsec_ != 0L) {
                output.writeInt64(3, this.creationTimeUsec_);
            }
            if (this.projectNumber_ != 0L) {
                output.writeInt64(4, this.projectNumber_);
            }
            if (this.backendPort_ != 0) {
                output.writeInt32(5, this.backendPort_);
            }
            for (int i = 0; i < this.rawBackendAddress_.size(); ++i) {
                output.writeBytes(6, this.rawBackendAddress_.get(i));
            }
            this.unknownFields.writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.handle_ != 0L) {
                size += CodedOutputStream.computeFixed64Size(2, this.handle_);
            }
            if (this.creationTimeUsec_ != 0L) {
                size += CodedOutputStream.computeInt64Size(3, this.creationTimeUsec_);
            }
            if (this.projectNumber_ != 0L) {
                size += CodedOutputStream.computeInt64Size(4, this.projectNumber_);
            }
            if (this.backendPort_ != 0) {
                size += CodedOutputStream.computeInt32Size(5, this.backendPort_);
            }
            int dataSize = 0;
            for (int i = 0; i < this.rawBackendAddress_.size(); ++i) {
                dataSize += CodedOutputStream.computeBytesSizeNoTag(this.rawBackendAddress_.get(i));
            }
            size += dataSize;
            size += 1 * this.getRawBackendAddressList().size();
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProtectedData)) {
                return super.equals(obj);
            }
            ProtectedData other = (ProtectedData)obj;
            if (!this.getRawBackendAddressList().equals(other.getRawBackendAddressList())) {
                return false;
            }
            if (this.getBackendPort() != other.getBackendPort()) {
                return false;
            }
            if (this.getHandle() != other.getHandle()) {
                return false;
            }
            if (this.getCreationTimeUsec() != other.getCreationTimeUsec()) {
                return false;
            }
            if (this.getProjectNumber() != other.getProjectNumber()) {
                return false;
            }
            return this.unknownFields.equals(other.unknownFields);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ProtectedData.getDescriptor().hashCode();
            if (this.getRawBackendAddressCount() > 0) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getRawBackendAddressList().hashCode();
            }
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getBackendPort();
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong(this.getHandle());
            hash = 37 * hash + 3;
            hash = 53 * hash + Internal.hashLong(this.getCreationTimeUsec());
            hash = 37 * hash + 4;
            hash = 53 * hash + Internal.hashLong(this.getProjectNumber());
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        @Override
        protected MutableMessage internalMutableDefault() {
            return MutableDefaultLoader.get();
        }

        public static ProtectedData parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ProtectedData parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProtectedData parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ProtectedData parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProtectedData parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ProtectedData parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProtectedData parseFrom(InputStream input) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static ProtectedData parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static ProtectedData parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static ProtectedData parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static ProtectedData parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static ProtectedData parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return ProtectedData.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ProtectedData prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ProtectedData getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ProtectedData> parser() {
            return PARSER;
        }

        public Parser<ProtectedData> getParserForType() {
            return PARSER;
        }

        @Override
        public ProtectedData getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements ProtectedDataOrBuilder {
            private int bitField0_;
            private List<ByteString> rawBackendAddress_ = Collections.emptyList();
            private int backendPort_;
            private long handle_;
            private long creationTimeUsec_;
            private long projectNumber_;

            public static final Descriptors.Descriptor getDescriptor() {
                return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_ProtectedData_descriptor;
            }

            @Override
            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_ProtectedData_fieldAccessorTable.ensureFieldAccessorsInitialized(ProtectedData.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessage.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            @Override
            public Builder clear() {
                super.clear();
                this.rawBackendAddress_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.backendPort_ = 0;
                this.handle_ = 0L;
                this.creationTimeUsec_ = 0L;
                this.projectNumber_ = 0L;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return DatastoreInternalProto.internal_static_cloud_datastore_internal_Transaction_ProtectedData_descriptor;
            }

            @Override
            public ProtectedData getDefaultInstanceForType() {
                return ProtectedData.getDefaultInstance();
            }

            @Override
            public ProtectedData build() {
                ProtectedData result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public ProtectedData buildPartial() {
                ProtectedData result = new ProtectedData(this);
                int from_bitField0_ = this.bitField0_;
                if ((this.bitField0_ & 1) != 0) {
                    this.rawBackendAddress_ = Collections.unmodifiableList(this.rawBackendAddress_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.rawBackendAddress_ = this.rawBackendAddress_;
                result.backendPort_ = this.backendPort_;
                result.handle_ = this.handle_;
                result.creationTimeUsec_ = this.creationTimeUsec_;
                result.projectNumber_ = this.projectNumber_;
                this.onBuilt();
                return result;
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof ProtectedData) {
                    return this.mergeFrom((ProtectedData)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ProtectedData other) {
                if (other == ProtectedData.getDefaultInstance()) {
                    return this;
                }
                if (!other.rawBackendAddress_.isEmpty()) {
                    if (this.rawBackendAddress_.isEmpty()) {
                        this.rawBackendAddress_ = other.rawBackendAddress_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureRawBackendAddressIsMutable();
                        this.rawBackendAddress_.addAll(other.rawBackendAddress_);
                    }
                    this.onChanged();
                }
                if (other.getBackendPort() != 0) {
                    this.setBackendPort(other.getBackendPort());
                }
                if (other.getHandle() != 0L) {
                    this.setHandle(other.getHandle());
                }
                if (other.getCreationTimeUsec() != 0L) {
                    this.setCreationTimeUsec(other.getCreationTimeUsec());
                }
                if (other.getProjectNumber() != 0L) {
                    this.setProjectNumber(other.getProjectNumber());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                ProtectedData parsedMessage = null;
                try {
                    parsedMessage = (ProtectedData)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (ProtectedData)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private void ensureRawBackendAddressIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.rawBackendAddress_ = new ArrayList<ByteString>(this.rawBackendAddress_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<ByteString> getRawBackendAddressList() {
                return (this.bitField0_ & 1) != 0 ? Collections.unmodifiableList(this.rawBackendAddress_) : this.rawBackendAddress_;
            }

            @Override
            public int getRawBackendAddressCount() {
                return this.rawBackendAddress_.size();
            }

            @Override
            public ByteString getRawBackendAddress(int index) {
                return this.rawBackendAddress_.get(index);
            }

            public Builder setRawBackendAddress(int index, ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRawBackendAddressIsMutable();
                this.rawBackendAddress_.set(index, value);
                this.onChanged();
                return this;
            }

            public Builder addRawBackendAddress(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRawBackendAddressIsMutable();
                this.rawBackendAddress_.add(value);
                this.onChanged();
                return this;
            }

            public Builder addAllRawBackendAddress(Iterable<? extends ByteString> values) {
                this.ensureRawBackendAddressIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.rawBackendAddress_);
                this.onChanged();
                return this;
            }

            public Builder clearRawBackendAddress() {
                this.rawBackendAddress_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            @Override
            public int getBackendPort() {
                return this.backendPort_;
            }

            public Builder setBackendPort(int value) {
                this.backendPort_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearBackendPort() {
                this.backendPort_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public long getHandle() {
                return this.handle_;
            }

            public Builder setHandle(long value) {
                this.handle_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearHandle() {
                this.handle_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public long getCreationTimeUsec() {
                return this.creationTimeUsec_;
            }

            public Builder setCreationTimeUsec(long value) {
                this.creationTimeUsec_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearCreationTimeUsec() {
                this.creationTimeUsec_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public long getProjectNumber() {
                return this.projectNumber_;
            }

            public Builder setProjectNumber(long value) {
                this.projectNumber_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearProjectNumber() {
                this.projectNumber_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }
        }

        private static final class MutableDefaultLoader {
            private static final Object defaultOrRuntimeException;

            private MutableDefaultLoader() {
            }

            public static MutableMessage get() {
                if (defaultOrRuntimeException instanceof RuntimeException) {
                    throw (RuntimeException)defaultOrRuntimeException;
                }
                return (MutableMessage)defaultOrRuntimeException;
            }

            static {
                Object local;
                try {
                    local = ProtectedData.internalMutableDefault("com.google.cloud.datastore.internal.proto1api.Transaction$ProtectedData");
                }
                catch (RuntimeException e) {
                    local = e;
                }
                defaultOrRuntimeException = local;
            }
        }
    }

    public static interface ProtectedDataOrBuilder
    extends MessageOrBuilder {
        public List<ByteString> getRawBackendAddressList();

        public int getRawBackendAddressCount();

        public ByteString getRawBackendAddress(int var1);

        public int getBackendPort();

        public long getHandle();

        public long getCreationTimeUsec();

        public long getProjectNumber();
    }
}

