/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.context.Context;
import com.google.common.context.ContextBuilder;
import com.google.monitoring.census.TagSet;
import com.google.security.context.SecurityContext;
import com.google.tracing.CurrentContext;
import com.google.tracing.GenericContext;
import com.google.tracing.TraceContext;

final class ContextImpl {
    static final ContextOnGenericContext backgroundContext = (ContextOnGenericContext)ContextImpl.genericToContext(CurrentContext.getDefaultContext());

    private ContextImpl() {
    }

    public static Context genericToContext(GenericContext gc) {
        GenericContext.TypedContextBase base = gc.getWrapper();
        if (base != null) {
            return (ContextOnGenericContext)base;
        }
        ContextOnGenericContext wrapper = new ContextOnGenericContext(gc);
        gc.setWrapper((GenericContext.TypedContextBase)wrapper);
        return wrapper;
    }

    static Context currentContext() {
        return ContextImpl.genericToContext(CurrentContext.currentContext());
    }

    static class GenericContextBuilder
    implements ContextBuilder {
        private final Context base;
        private SecurityContext newSecurityContext;
        private TraceContext newTraceContext;
        private TagSet newCensusHandle;

        public GenericContextBuilder(Context baseContext) {
            this.base = baseContext;
        }

        @Override
        public ContextBuilder replaceSecurityContext(SecurityContext newSecurityContext) {
            this.newSecurityContext = Preconditions.checkNotNull(newSecurityContext);
            return this;
        }

        @Override
        public ContextBuilder replaceTraceContext(TraceContext newTraceContext) {
            this.newTraceContext = Preconditions.checkNotNull(newTraceContext);
            return this;
        }

        @Override
        public ContextBuilder replaceCensusHandle(TagSet newCensusHandle) {
            this.newCensusHandle = Preconditions.checkNotNull(newCensusHandle);
            return this;
        }

        @Override
        public Context build() {
            if (this.newTraceContext == null && this.newSecurityContext == null && this.newCensusHandle == null) {
                return this.base;
            }
            if (this.base instanceof ContextOnGenericContext) {
                GenericContext gc = ((ContextOnGenericContext)this.base).asGenericContext();
                if (this.newTraceContext != null) {
                    gc = gc.withTrace((GenericContext.TraceBase)this.newTraceContext);
                }
                if (this.newSecurityContext != null) {
                    gc = gc.withSecurity((GenericContext.SecurityBase)this.newSecurityContext);
                }
                if (this.newCensusHandle != null) {
                    gc = gc.withCensusHandle(this.newCensusHandle);
                }
                return new ContextOnGenericContext(gc);
            }
            return new ContextOnGenericContext(CurrentContext.currentContext().withTrace((GenericContext.TraceBase)MoreObjects.firstNonNull(this.newTraceContext, this.base.getTraceContext())).withSecurity((GenericContext.SecurityBase)MoreObjects.firstNonNull(this.newSecurityContext, this.base.getSecurityContext())).withCensusHandle(MoreObjects.firstNonNull(this.newCensusHandle, this.base.getCensusHandle())));
        }
    }

    static class ContextOnGenericContext
    extends Context
    implements GenericContext.TypedContextBase {
        private final GenericContext gc;

        @VisibleForTesting
        ContextOnGenericContext(GenericContext gc) {
            this.gc = gc;
        }

        @Override
        public SecurityContext getSecurityContext() {
            SecurityContext sc = (SecurityContext)this.gc.getSecurity();
            return sc != null ? sc : SecurityContext.BACKGROUND_SECURITY_CONTEXT;
        }

        @Override
        public TraceContext getTraceContext() {
            TraceContext tc = (TraceContext)this.gc.getTrace();
            return tc != null ? tc : TraceContext.nullContext();
        }

        @Override
        public TagSet getCensusHandle() {
            TagSet ch = this.gc.getCensusHandle();
            return ch != null ? ch : TagSet.getDefault();
        }

        @Override
        GenericContext asGenericContext() {
            return this.gc;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ContextOnGenericContext)) {
                return false;
            }
            return this.gc.equals((Object)((ContextOnGenericContext)other).asGenericContext());
        }

        public int hashCode() {
            return this.gc.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("genericContext", this.gc.toString()).toString();
        }
    }
}

