/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags.ext;

import com.google.common.base.Strings;
import com.google.common.flags.Flag;
import com.google.common.flags.InvalidFlagValueException;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class JodaDateTimeFlag
extends Flag<DateTime> {
    private final DateTimeFormatter format;

    public static JodaDateTimeFlag now() {
        return new JodaDateTimeFlag(DateTime.now());
    }

    public static JodaDateTimeFlag yesterday() {
        return new JodaDateTimeFlag(DateTime.now().minus(Duration.standardDays(1L)));
    }

    public static JodaDateTimeFlag tomorrow() {
        return new JodaDateTimeFlag(DateTime.now().plus(Duration.standardDays(1L)));
    }

    public JodaDateTimeFlag(@Nullable DateTime defaultValue) {
        this(defaultValue, DateTimeZone.UTC);
    }

    public JodaDateTimeFlag(@Nullable DateTime defaultValue, DateTimeZone zone) {
        this(defaultValue, ISODateTimeFormat.dateTimeParser().withZone(zone));
    }

    public JodaDateTimeFlag(@Nullable DateTime defaultValue, DateTimeFormatter format) {
        super(defaultValue);
        this.format = format;
    }

    public static JodaDateTimeFlag nullValue() {
        return new JodaDateTimeFlag(null);
    }

    @Override
    protected DateTime parse(String value) throws InvalidFlagValueException {
        try {
            return this.format.parseDateTime(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagValueException(e.getMessage());
        }
    }

    @Override
    protected String parsableStringValue(DateTime value) {
        if (this.format.isPrinter()) {
            return this.format.print(value);
        }
        return super.parsableStringValue(value);
    }

    public static final class JodaDateTimeFlagFactory {
        public static Flag<DateTime> value(@Nullable DateTime defaultValue) {
            return new JodaDateTimeFlag(defaultValue);
        }

        @Nullable
        public static DateTime valueOf(@Nullable String value) {
            return Strings.isNullOrEmpty(value) ? null : DateTime.parse(value);
        }
    }
}

