/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags.ext;

import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.flags.InvalidFlagValueException;
import java.util.LinkedHashMap;

final class MapUtils {
    private MapUtils() {
    }

    static <K, V> ImmutableMap<K, V> parseMap(String text, Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator, boolean overwriteDuplicateKeys) throws InvalidFlagValueException {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(keyConverter);
        Preconditions.checkNotNull(valueConverter);
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        if (!CharMatcher.whitespace().matchesAllOf(text)) {
            for (String s : Splitter.on(entrySeparator).split(text)) {
                int index = s.indexOf(keyValueSeparator);
                if (index == -1) {
                    String string = String.valueOf(s);
                    throw new InvalidFlagValueException(string.length() != 0 ? "Invalid map entry syntax ".concat(string) : new String("Invalid map entry syntax "));
                }
                String keyStr = CharMatcher.whitespace().trimFrom(s.substring(0, index));
                K key = MapUtils.convertKey(keyStr, keyConverter);
                if (!overwriteDuplicateKeys && result.containsKey(key)) {
                    throw new InvalidFlagValueException(String.format("Duplicate map key '%s' in '%s'", keyStr, text));
                }
                String valStr = CharMatcher.whitespace().trimFrom(s.substring(index + 1));
                V value = MapUtils.convertValue(keyStr, valStr, valueConverter);
                result.put(key, value);
            }
        }
        return ImmutableMap.copyOf(result);
    }

    static <K, V> ImmutableSetMultimap<K, V> parseSetMultimap(String text, Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator, char valueSeparator, boolean overwriteDuplicateKeys) throws InvalidFlagValueException {
        return ImmutableSetMultimap.copyOf(MapUtils.parseListMultimap(text, keyConverter, valueConverter, entrySeparator, keyValueSeparator, valueSeparator, overwriteDuplicateKeys));
    }

    static <K, V> ImmutableListMultimap<K, V> parseListMultimap(String text, Converter<String, K> keyConverter, Converter<String, V> valueConverter, char entrySeparator, char keyValueSeparator, char valueSeparator, boolean overwriteDuplicateKeys) throws InvalidFlagValueException {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(keyConverter);
        Preconditions.checkNotNull(valueConverter);
        ArrayListMultimap<K, V> result = ArrayListMultimap.create();
        if (!CharMatcher.whitespace().matchesAllOf(text)) {
            Splitter valueSplitter = Splitter.on(valueSeparator);
            for (String s : Splitter.on(entrySeparator).split(text)) {
                int index = s.indexOf(keyValueSeparator);
                if (index == -1) {
                    String string = String.valueOf(s);
                    throw new InvalidFlagValueException(string.length() != 0 ? "Invalid map entry syntax ".concat(string) : new String("Invalid map entry syntax "));
                }
                String keyStr = CharMatcher.whitespace().trimFrom(s.substring(0, index));
                K key = MapUtils.convertKey(keyStr, keyConverter);
                if (!overwriteDuplicateKeys && result.containsKey(key)) {
                    throw new InvalidFlagValueException(String.format("Duplicate map key '%s' in '%s'", keyStr, text));
                }
                result.removeAll(key);
                String allValStr = CharMatcher.whitespace().trimFrom(s.substring(index + 1));
                for (String valStr : valueSplitter.split(allValStr)) {
                    result.put(key, MapUtils.convertValue(keyStr, valStr.trim(), valueConverter));
                }
            }
        }
        return ImmutableListMultimap.copyOf(result);
    }

    private static <K> K convertKey(String keyStr, Converter<String, K> keyConverter) throws InvalidFlagValueException {
        try {
            return keyConverter.convert(keyStr);
        }
        catch (Exception e) {
            throw new InvalidFlagValueException(String.format("Error parsing map key '%s'", keyStr), e);
        }
    }

    private static <V> V convertValue(String keyStr, String valStr, Converter<String, V> valueConverter) throws InvalidFlagValueException {
        try {
            return valueConverter.convert(valStr);
        }
        catch (Exception e) {
            throw new InvalidFlagValueException(String.format("Error parsing map value '%s' for key '%s'", valStr, keyStr), e);
        }
    }
}

