/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.util.Checks;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class LogSiteStats {
    private static final StatsMap map = new StatsMap();
    private final AtomicLong invocationCount = new AtomicLong();
    private final AtomicLong lastTimestampNanos = new AtomicLong();
    private final AtomicInteger skippedLogStatements = new AtomicInteger();

    LogSiteStats() {
    }

    static RateLimitPeriod newRateLimitPeriod(int n, TimeUnit unit) {
        return new RateLimitPeriod(n, unit);
    }

    public static LogSiteStats getStatsForKey(Object logSiteKey) {
        return map.getStatsForKey(logSiteKey);
    }

    boolean incrementAndCheckInvocationCount(int rateLimitCount) {
        return this.invocationCount.getAndIncrement() % (long)rateLimitCount == 0L;
    }

    boolean checkLastTimestamp(long timestampNanos, RateLimitPeriod period) {
        long lastNanos = this.lastTimestampNanos.get();
        long deadlineNanos = lastNanos + period.toNanos();
        if (deadlineNanos >= 0L && (timestampNanos >= deadlineNanos || lastNanos == 0L) && this.lastTimestampNanos.compareAndSet(lastNanos, timestampNanos)) {
            period.setSkipCount(this.skippedLogStatements.getAndSet(0));
            return true;
        }
        this.skippedLogStatements.incrementAndGet();
        return false;
    }

    static final class StatsMap {
        private final ConcurrentMap<Object, LogSiteStats> statsMap = new ConcurrentHashMap<Object, LogSiteStats>();

        StatsMap() {
        }

        LogSiteStats getStatsForKey(Object logSiteKey) {
            LogSiteStats oldStats;
            LogSiteStats stats = (LogSiteStats)this.statsMap.get(logSiteKey);
            if (stats == null && (oldStats = this.statsMap.putIfAbsent(logSiteKey, stats = new LogSiteStats())) != null) {
                stats = oldStats;
            }
            return stats;
        }
    }

    static final class RateLimitPeriod {
        private final int n;
        private final TimeUnit unit;
        private int skipCount = -1;

        private RateLimitPeriod(int n, TimeUnit unit) {
            if (n <= 0) {
                throw new IllegalArgumentException(new StringBuilder(41).append("time period must be positive: ").append(n).toString());
            }
            this.n = n;
            this.unit = Checks.checkNotNull(unit, "time unit");
        }

        private long toNanos() {
            return this.unit.toNanos(this.n);
        }

        private void setSkipCount(int skipCount) {
            this.skipCount = skipCount;
        }

        public String toString() {
            StringBuilder out = new StringBuilder().append(this.n).append(' ').append((Object)this.unit);
            if (this.skipCount > 0) {
                out.append(" [skipped: ").append(this.skipCount).append(']');
            }
            return out.toString();
        }

        public int hashCode() {
            return this.n * 37 ^ this.unit.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RateLimitPeriod) {
                RateLimitPeriod that = (RateLimitPeriod)obj;
                return this.n == that.n && this.unit == that.unit;
            }
            return false;
        }
    }
}

