/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractCompositeHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;

@GoogleInternal
final class Fingerprint1999
extends AbstractCompositeHashFunction {
    private final String toString;

    Fingerprint1999(HashFunction function1, HashFunction function2, String toString) {
        super(function1, function2);
        this.toString = Preconditions.checkNotNull(toString);
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return this.toString;
    }

    @Override
    HashCode makeHash(Hasher[] hashers) {
        return Fingerprint1999.combineFingerprintHalves(hashers[0].hash().asInt(), hashers[1].hash().asInt());
    }

    @VisibleForTesting
    static HashCode combineFingerprintHalves(int hi, int lo) {
        if (hi == 0 && lo == 0) {
            return HashCode.fromLong(1373487864664336680L);
        }
        if (hi == 0 && lo == 1) {
            return HashCode.fromLong(1373487864664336681L);
        }
        return HashCode.fromLong((long)hi << 32 | (long)lo & 0xFFFFFFFFL);
    }
}

