/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GoogleInternal;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@GoogleInternal
final class Murmur2_64AHashFunction
extends AbstractNonStreamingHashFunction {
    static final HashFunction MURMUR_HASH_2_64 = new Murmur2_64AHashFunction(0L);
    private static final long M = -4132994306676758123L;
    private static final int R = 47;
    private final long seed;

    Murmur2_64AHashFunction(long seed) {
        this.seed = seed;
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        ByteBuffer buf = ByteBuffer.wrap(input, off, len).order(ByteOrder.LITTLE_ENDIAN);
        long h = this.seed ^ (long)buf.remaining() * -4132994306676758123L;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        if (buf.hasRemaining()) {
            int i = 0;
            while (buf.hasRemaining()) {
                h ^= ((long)buf.get() & 0xFFL) << i;
                i += 8;
            }
            h *= -4132994306676758123L;
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return HashCode.fromLong(h);
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        long l = this.seed;
        return new StringBuilder(40).append("Hashing.murmur2_64(").append(l).append(")").toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur2_64AHashFunction) {
            Murmur2_64AHashFunction that = (Murmur2_64AHashFunction)object;
            return this.seed == that.seed;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seed ^ (long)this.getClass().hashCode());
    }
}

