/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashFunction;
import com.google.common.hash.TradeSecretHashing;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;

@GoogleInternal
public final class WeightedConsistentHash<B, I> {
    private final HashFunction hashFunction;
    private final Funnel<B> bucketFunnel;
    private final Funnel<I> inputFunnel;
    private final Map<B, Double> bucketWeights = new HashMap<B, Double>();

    private WeightedConsistentHash(HashFunction hashFunction, Funnel<B> bucketFunnel, Funnel<I> inputFunnel) {
        this.hashFunction = Preconditions.checkNotNull(hashFunction);
        this.bucketFunnel = Preconditions.checkNotNull(bucketFunnel);
        this.inputFunnel = Preconditions.checkNotNull(inputFunnel);
    }

    public static <B, I> WeightedConsistentHash<B, I> create(Funnel<B> bucketFunnel, Funnel<I> inputFunnel) {
        return new WeightedConsistentHash<B, I>(TradeSecretHashing.fingerprint2011(), bucketFunnel, inputFunnel);
    }

    public void setBucketWeight(B bucketId, double weight) {
        Preconditions.checkNotNull(bucketId);
        Preconditions.checkArgument(weight >= 0.0, "Weight (%s) must be non-negative.", (Object)weight);
        if (weight == 0.0) {
            this.bucketWeights.remove(bucketId);
        } else {
            this.bucketWeights.put(bucketId, weight);
        }
    }

    public B hash(I input) {
        Preconditions.checkNotNull(input);
        Preconditions.checkState(!this.bucketWeights.isEmpty(), "No positive weight.");
        B highestBucketId = null;
        double highestAffinity = Double.NEGATIVE_INFINITY;
        for (Map.Entry<B, Double> entry : this.bucketWeights.entrySet()) {
            double affinity = Math.log(this.affinity(input, entry.getKey())) / entry.getValue();
            if (!(affinity > highestAffinity)) continue;
            highestAffinity = affinity;
            highestBucketId = entry.getKey();
        }
        return highestBucketId;
    }

    @VisibleForTesting
    double affinity(I input, B bucketKey) {
        long hash = this.hashFunction.newHasher().putObject(input, this.inputFunnel).putObject(bucketKey, this.bucketFunnel).hash().asLong();
        return UnsignedLong.fromLongBits(hash).doubleValue() / UnsignedLong.MAX_VALUE.doubleValue();
    }
}

