/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.html.HtmlEscaper;
import com.google.common.html.HtmlTextHandler;
import com.google.common.html.LinkDetector;
import com.google.httputil.Mailto;

@GoogleInternal
@GwtIncompatible
public final class HTMLifier {
    public static final int ESCAPE_MODE = 1;
    public static final int LINEBREAK_MODE = 2;
    public static final int LINKIFY_MODE = 4;
    public static final int MS_ASCII_MODE = 8;
    public static final int LATIN_1_MODE = 16;
    public static final int END_LINKS_AT_NEW_LINE_MODE = 32;
    static final int ALL_MODES = 63;
    private final int mode;
    private static final HtmlEscaper ATTRIBUTE_ESCAPER = new HtmlEscaper.Builder().escapeReservedHtmlChars(true).create();

    public HTMLifier(int mode) {
        Preconditions.checkArgument(mode != 0 && (mode | 0x3F) == 63);
        this.mode = mode;
    }

    public final String HTMLify(String text) {
        TextHandler handler = new TextHandler(this.mode);
        if ((4 & this.mode) != 0) {
            LinkDetector linkDetector = new LinkDetector();
            linkDetector.setEndLinksOnNewLine((0x20 & this.mode) != 0);
            linkDetector.process(text, handler);
        } else {
            handler.handlePlainText(text, 0, text.length());
        }
        return handler.getOutput();
    }

    private static class TextHandler
    implements HtmlTextHandler {
        private final StringBuilder out = new StringBuilder();
        private final HtmlEscaper escaper;

        TextHandler(int mode) {
            this.escaper = new HtmlEscaper.Builder().escapeReservedHtmlChars((1 & mode) != 0).convertLineBreaksToTags((2 & mode) != 0).convertLatin1ToEntities((0x10 & mode) != 0).convertMsExtensionsToEntities((8 & mode) != 0).create();
        }

        @Override
        public void handlePlainText(String text, int start, int end) {
            this.escaper.escapeTo(text.substring(start, end), this.out);
        }

        @Override
        public void handleUrl(String url, String desc) {
            this.out.append("<a href=\"");
            ATTRIBUTE_ESCAPER.escapeTo(url, this.out);
            this.out.append("\">");
            this.handlePlainText(desc, 0, desc.length());
            this.out.append("</a>");
        }

        @Override
        public void handleMailAddress(String address, String desc) {
            this.handleUrl(new Mailto().addTo(address).toUriString(), desc);
        }

        private String getOutput() {
            return this.out.toString();
        }
    }
}

