/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.StringUtil;
import com.google.common.collect.ImmutableMap;
import com.google.i18n.TextWrapper;
import java.util.Map;

@Deprecated
@GoogleInternal
@GwtIncompatible
public final class HtmlToText {
    private static final CharMatcher NOT_WHITESPACE = CharMatcher.whitespace().negate();
    private static final ImmutableMap<String, String> TAG_REPLACEMENT_MAP = ImmutableMap.of("li", "\n- ", "br", "\n", "p", "\n", "/p", "\n");
    private static final int EMAIL_LINE_WIDTH_MAX = 72;
    private static final String NON_LINE_BREAK_WS = " \t\u3000\u00a0\u2007\u202f";
    private static final ImmutableMap<String, Boolean> WRAP_OPTIONS = ImmutableMap.of("CollapseWs", Boolean.TRUE, "NoEolWs", Boolean.TRUE);

    private HtmlToText() {
    }

    @Deprecated
    public static String htmlToPlainTextNoWrap(String html) {
        if (html == null) {
            throw new NullPointerException("Html parameter may not be null.");
        }
        String text = CharMatcher.breakingWhitespace().trimAndCollapseFrom(html, ' ');
        text = HtmlToText.convertHtmlTagsToText(text);
        text = CharMatcher.breakingWhitespace().trimFrom(StringUtil.unescapeHTML(text));
        return text;
    }

    @Deprecated
    public static String htmlToPlainText(String html) {
        String text = HtmlToText.htmlToPlainTextNoWrap(html);
        text = CharMatcher.anyOf(NON_LINE_BREAK_WS).collapseFrom(text, ' ');
        return TextWrapper.wrap(text, 72, WRAP_OPTIONS);
    }

    private static String convertHtmlTagsToText(String html) {
        int len = html.length();
        StringBuilder sb = new StringBuilder(len);
        int lastTagStart = len;
        int copyStart = 0;
        block4: for (int i = 0; i < len; ++i) {
            switch (html.charAt(i)) {
                case '<': {
                    lastTagStart = i;
                    continue block4;
                }
                case '>': {
                    if (lastTagStart >= i) continue block4;
                    int leadingTagWhitespaceStart = HtmlToText.findLeadingWhitespaceStart(html, copyStart, lastTagStart);
                    sb.append(html, copyStart, leadingTagWhitespaceStart);
                    if (HtmlToText.replaceTag(sb, html, lastTagStart + 1)) {
                        if ((i = NOT_WHITESPACE.indexIn(html, i + 1) - 1) < 0) {
                            i = len;
                        }
                    } else {
                        sb.append(html, leadingTagWhitespaceStart, lastTagStart);
                    }
                    copyStart = i + 1;
                    lastTagStart = len;
                }
            }
        }
        if (copyStart < len) {
            sb.append(html, copyStart, len);
        }
        return sb.toString();
    }

    private static boolean replaceTag(StringBuilder sb, String html, int index) {
        for (Map.Entry entry : TAG_REPLACEMENT_MAP.entrySet()) {
            String tag = (String)entry.getKey();
            if (!tag.regionMatches(true, 0, html, index, tag.length())) continue;
            sb.append((String)entry.getValue());
            return true;
        }
        return false;
    }

    private static final int findLeadingWhitespaceStart(String html, int startIndex, int endIndex) {
        int leadingWhitespace = endIndex;
        while (--leadingWhitespace > startIndex && CharMatcher.whitespace().matches(html.charAt(leadingWhitespace))) {
        }
        return leadingWhitespace + 1;
    }
}

