/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.html.types.BuilderUtils;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;

@CheckReturnValue
@GwtCompatible(emulated=true)
public final class SafeHtmls {
    @GwtIncompatible(value="Resources")
    public static SafeHtml fromResource(@CompileTimeConstant String resourceName) throws IOException {
        return SafeHtmls.create(Resources.toString(Resources.getResource(resourceName), Charset.forName("UTF-8")));
    }

    @GwtIncompatible(value="Resources")
    public static SafeHtml fromResource(Class<?> contextClass, @CompileTimeConstant String resourceName) throws IOException {
        return SafeHtmls.create(Resources.toString(Resources.getResource(contextClass, resourceName), Charset.forName("UTF-8")));
    }

    public static SafeHtml fromProto(SafeHtmlProto proto) {
        return SafeHtmls.create(proto.getPrivateDoNotAccessOrElseSafeHtmlWrappedValue());
    }

    public static SafeHtml fromScript(SafeScript script) {
        String string = script.getSafeScriptString();
        return SafeHtmls.create(new StringBuilder(40 + String.valueOf(string).length()).append("<script type=\"text/javascript\">").append(string).append("</script>").toString());
    }

    public static SafeHtml fromScriptWithCspNonce(SafeScript script, String cspNonce) {
        String string = SafeHtmls.htmlEscapeInternal(cspNonce);
        String string2 = script.getSafeScriptString();
        return SafeHtmls.create(new StringBuilder(49 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<script type=\"text/javascript\" nonce=\"").append(string).append("\">").append(string2).append("</script>").toString());
    }

    public static SafeHtml fromScriptUrl(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create(new StringBuilder(47 + String.valueOf(escapedUrl).length()).append("<script type=\"text/javascript\" src=\"").append(escapedUrl).append("\"></script>").toString());
    }

    public static SafeHtml fromScriptUrlDeferred(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create(new StringBuilder(53 + String.valueOf(escapedUrl).length()).append("<script defer type=\"text/javascript\" src=\"").append(escapedUrl).append("\"></script>").toString());
    }

    public static SafeHtml fromScriptUrlWithCspNonce(TrustedResourceUrl trustedResourceUrl, String cspNonce) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        String string = SafeHtmls.htmlEscapeInternal(cspNonce);
        return SafeHtmls.create(new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(escapedUrl).length()).append("<script type=\"text/javascript\" nonce=\"").append(string).append("\" src=\"").append(escapedUrl).append("\"></script>").toString());
    }

    public static SafeHtml fromScriptUrlWithCspNonceDeferred(TrustedResourceUrl trustedResourceUrl, String cspNonce) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        String string = SafeHtmls.htmlEscapeInternal(cspNonce);
        return SafeHtmls.create(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(escapedUrl).length()).append("<script defer type=\"text/javascript\" nonce=\"").append(string).append("\" src=\"").append(escapedUrl).append("\"></script>").toString());
    }

    public static SafeHtml fromStyleSheet(SafeStyleSheet safeStyleSheet) {
        Preconditions.checkArgument(!safeStyleSheet.getSafeStyleSheetString().contains("<"));
        String string = safeStyleSheet.getSafeStyleSheetString();
        return SafeHtmls.create(new StringBuilder(31 + String.valueOf(string).length()).append("<style type=\"text/css\">").append(string).append("</style>").toString());
    }

    public static SafeHtml fromStyleUrl(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create(new StringBuilder(31 + String.valueOf(escapedUrl).length()).append("<link rel=\"stylesheet\" href=\"").append(escapedUrl).append("\">").toString());
    }

    public static SafeHtmlProto toProto(SafeHtml safeHtml) {
        return SafeHtmlProto.newBuilder().setPrivateDoNotAccessOrElseSafeHtmlWrappedValue(safeHtml.getSafeHtmlString()).build();
    }

    public static SafeHtml htmlEscape(String text) {
        return SafeHtmls.create(SafeHtmls.htmlEscapeInternal(text));
    }

    public static SafeHtml htmlEscapePreservingNewlines(String text) {
        return SafeHtmls.create(SafeHtmls.htmlEscapeInternal(text).replaceAll("\r?\n|\r", "<br>"));
    }

    public static SafeHtml comment(String text) {
        String string = SafeHtmls.htmlEscapeInternal(text);
        return SafeHtmls.create(new StringBuilder(7 + String.valueOf(string).length()).append("<!--").append(string).append("-->").toString());
    }

    public static SafeHtml concat(SafeHtml ... htmls) {
        return SafeHtmls.concat(Arrays.asList(htmls));
    }

    public static SafeHtml concat(Iterable<SafeHtml> htmls) {
        int concatLength = 0;
        for (SafeHtml html : htmls) {
            concatLength += html.getSafeHtmlString().length();
        }
        StringBuilder result = new StringBuilder(concatLength);
        for (SafeHtml html : htmls) {
            result.append(html.getSafeHtmlString());
        }
        return SafeHtmls.create(result.toString());
    }

    static SafeHtml create(String html) {
        return new SafeHtml(html);
    }

    private static String htmlEscapeInternal(String text) {
        return BuilderUtils.escapeHtmlInternal(BuilderUtils.coerceToInterchangeValid(text));
    }

    private SafeHtmls() {
    }
}

