/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;

@CheckReturnValue
@GwtCompatible(emulated=true)
public final class SafeStyleSheets {
    private SafeStyleSheets() {
    }

    public static SafeStyleSheet fromConstant(@CompileTimeConstant String styleSheet) {
        if (styleSheet.length() == 0) {
            return SafeStyleSheet.EMPTY;
        }
        for (int i = 0; i < styleSheet.length(); ++i) {
            if (styleSheet.charAt(i) != '<') continue;
            String string = String.valueOf(styleSheet);
            throw new IllegalArgumentException(string.length() != 0 ? "Forbidden '<' character in style sheet string: ".concat(string) : new String("Forbidden '<' character in style sheet string: "));
        }
        return SafeStyleSheets.create(styleSheet);
    }

    @GwtIncompatible(value="Resources")
    public static SafeStyleSheet fromResource(@CompileTimeConstant String resourceName, Charset charset) throws IOException {
        return SafeStyleSheets.create(Resources.toString(Resources.getResource(resourceName), charset));
    }

    @GwtIncompatible(value="Resources")
    public static SafeStyleSheet fromResource(Class<?> contextClass, @CompileTimeConstant String resourceName, Charset charset) throws IOException {
        return SafeStyleSheets.create(Resources.toString(Resources.getResource(contextClass, resourceName), charset));
    }

    public static SafeStyleSheet fromProto(SafeStyleSheetProto proto) {
        return SafeStyleSheets.create(proto.getPrivateDoNotAccessOrElseSafeStyleSheetWrappedValue());
    }

    public static SafeStyleSheetProto toProto(SafeStyleSheet style) {
        return SafeStyleSheetProto.newBuilder().setPrivateDoNotAccessOrElseSafeStyleSheetWrappedValue(style.getSafeStyleSheetString()).build();
    }

    public static SafeStyleSheet concat(SafeStyleSheet ... stylesheets) {
        return SafeStyleSheets.concat(Arrays.asList(stylesheets));
    }

    public static SafeStyleSheet concat(Iterable<SafeStyleSheet> stylesheets) {
        int concatLength = 0;
        for (SafeStyleSheet stylesheet : stylesheets) {
            concatLength += stylesheet.getSafeStyleSheetString().length();
        }
        StringBuilder result = new StringBuilder(concatLength);
        for (SafeStyleSheet stylesheet : stylesheets) {
            result.append(stylesheet.getSafeStyleSheetString());
        }
        return SafeStyleSheets.create(result.toString());
    }

    static SafeStyleSheet create(String style) {
        return new SafeStyleSheet(style);
    }
}

