/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.flags.Flag;
import com.google.common.html.types.CustomSafeUrlScheme;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.common.net.UrlEscapers;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
@GwtCompatible(emulated=true)
public final class SafeUrls {
    private static final Set<String> DEFAULT_SAFE_SCHEMES = SafeUrls.createUnmodifiableSet("http", "https", "mailto", "ftp");
    private static final String DATA_SCHEME = "data";
    private static final Set<String> SAFE_DATA_MIME_TYPES = SafeUrls.createUnmodifiableSet("audio/3gpp2", "audio/3gpp", "audio/aac", "audio/midi", "audio/mp3", "audio/mp4", "audio/mpeg", "audio/oga", "audio/ogg", "audio/opus", "audio/x-m4a", "audio/x-wav", "audio/wav", "audio/webm", "image/bmp", "image/gif", "image/jpeg", "image/jpg", "image/png", "image/tiff", "image/webp", "image/x-icon", "video/mpeg", "video/mp4", "video/ogg", "video/webm");
    private static final String DATA_BASE64_PREFIX = ";base64,";
    private static final Set<CustomSafeUrlScheme> EMPTY_CUSTOM_SCHEMES = Collections.emptySet();

    private SafeUrls() {
    }

    private static final Set<String> createUnmodifiableSet(String ... schemes) {
        HashSet<String> set = new HashSet<String>();
        for (String scheme : schemes) {
            set.add(scheme);
        }
        return Collections.unmodifiableSet(set);
    }

    public static SafeUrl fromProto(SafeUrlProto proto) {
        return SafeUrls.create(proto.getPrivateDoNotAccessOrElseSafeUrlWrappedValue());
    }

    public static SafeUrlProto toProto(SafeUrl url) {
        return SafeUrlProto.newBuilder().setPrivateDoNotAccessOrElseSafeUrlWrappedValue(url.getSafeUrlString()).build();
    }

    public static SafeUrl fromConstant(@CompileTimeConstant String url) {
        return SafeUrls.create(url);
    }

    @GwtIncompatible(value="Flag")
    public static Flag<SafeUrl> createFlag(@Nullable @CompileTimeConstant String defaultValue) {
        return new Flag<SafeUrl>(defaultValue == null ? null : SafeUrls.fromConstant(defaultValue)){

            @Override
            protected SafeUrl parse(String valueString) {
                return new SafeUrl(valueString);
            }

            @Override
            protected boolean isSetFromStringAllowed() {
                return false;
            }
        };
    }

    public static SafeUrl sanitize(String url) {
        return SafeUrls.sanitize(url, SafeUrl.INNOCUOUS);
    }

    public static SafeUrl sanitize(String url, SafeUrl innocuous) {
        return SafeUrls.sanitize(url, EMPTY_CUSTOM_SCHEMES, innocuous);
    }

    public static SafeUrl sanitize(String url, Set<CustomSafeUrlScheme> extraAllowedSchemes) {
        return SafeUrls.sanitize(url, extraAllowedSchemes, SafeUrl.INNOCUOUS);
    }

    public static SafeUrl sanitize(String url, Set<CustomSafeUrlScheme> extraAllowedSchemes, SafeUrl innocuous) {
        if (!SafeUrls.isSafeUrl(url, extraAllowedSchemes)) {
            return innocuous;
        }
        return SafeUrls.create(url);
    }

    public static String sanitizeAsString(String url, @CompileTimeConstant String identifier) {
        if (!SafeUrls.isSafeUrl(url, EMPTY_CUSTOM_SCHEMES)) {
            String string = String.valueOf(identifier);
            return string.length() != 0 ? "about:invalid#".concat(string) : new String("about:invalid#");
        }
        return url;
    }

    public static SafeUrl createHtmlDataUrl(SafeHtml html) {
        String string = String.valueOf(UrlEscapers.urlPathSegmentEscaper().escape(html.getSafeHtmlString()));
        String dataUrl = string.length() != 0 ? "data:text/html;charset=UTF-8,".concat(string) : new String("data:text/html;charset=UTF-8,");
        return SafeUrls.create(dataUrl);
    }

    public static SafeUrl createHtmlDataUrlBase64(SafeHtml html) {
        try {
            String string = String.valueOf(BaseEncoding.base64().encode(html.getSafeHtmlString().getBytes("UTF-8")));
            String dataUrl = string.length() != 0 ? "data:text/html;charset=UTF-8;base64,".concat(string) : new String("data:text/html;charset=UTF-8;base64,");
            return SafeUrls.create(dataUrl);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSafeUrl(String url, Set<CustomSafeUrlScheme> extraAllowedSchemes) {
        String lowerCased = url.toLowerCase();
        for (String string : DEFAULT_SAFE_SCHEMES) {
            if (!lowerCased.startsWith(String.valueOf(string).concat(":"))) continue;
            return true;
        }
        if (lowerCased.startsWith("data:")) {
            return SafeUrls.isSafeDataUrl(url);
        }
        for (CustomSafeUrlScheme customSafeUrlScheme : extraAllowedSchemes) {
            if (!lowerCased.startsWith(String.valueOf(customSafeUrlScheme.name().toLowerCase().replace('_', '-')).concat(":"))) continue;
            return true;
        }
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    return true;
                }
                case ':': {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isSafeDataUrl(String url) {
        char c;
        String lowerCased = url.toLowerCase();
        int pos = 0;
        if (!lowerCased.startsWith("data:")) {
            return false;
        }
        if ((pos += DATA_SCHEME.length() + 1) >= lowerCased.length()) {
            return false;
        }
        int mimeStartPos = pos;
        while (pos < lowerCased.length() && (c = lowerCased.charAt(pos)) != ';' && c != ',') {
            ++pos;
        }
        if (!SAFE_DATA_MIME_TYPES.contains(lowerCased.substring(mimeStartPos, pos))) {
            return false;
        }
        if (!lowerCased.startsWith(DATA_BASE64_PREFIX, pos)) {
            return false;
        }
        if ((pos += DATA_BASE64_PREFIX.length()) >= lowerCased.length()) {
            return false;
        }
        while (pos < lowerCased.length() && (c = lowerCased.charAt(pos)) != '=') {
            if (!('a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '+' || c == '/')) {
                return false;
            }
            ++pos;
        }
        while (pos < lowerCased.length()) {
            if (lowerCased.charAt(pos) != '=') {
                return false;
            }
            ++pos;
        }
        return true;
    }

    static SafeUrl create(String url) {
        return new SafeUrl(url);
    }
}

