/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingListIterator;
import com.google.common.collect.ForwardingListMultimap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

@GoogleInternal
@GwtCompatible
final class ConstrainedMultimaps {
    private ConstrainedMultimaps() {
    }

    static <K, V> ListMultimap<K, V> nullRejectingListMultimap(ListMultimap<K, V> multimap) {
        return new ConstrainedListMultimap<K, V>(multimap);
    }

    @VisibleForTesting
    static <E> List<E> nullRejectingList(List<E> list) {
        return new ConstrainedList<E>(list);
    }

    private static <K, V> Collection<V> checkValues(K key, Iterable<? extends V> values) {
        ArrayList copy = Lists.newArrayList(values);
        for (Object value : copy) {
            Preconditions.checkNotNull(key, "null key in entry (%s, %s)", key, value);
            Preconditions.checkNotNull(value, "null value in entry (%s, %s)", key, value);
        }
        return copy;
    }

    private static <E> Collection<E> checkElements(Collection<E> elements) {
        ArrayList<E> copy = Lists.newArrayList(elements);
        for (Object element : copy) {
            Preconditions.checkNotNull(element, "this list cannot contain null");
        }
        return copy;
    }

    private static class ConstrainedListIterator<E>
    extends ForwardingListIterator<E> {
        private final ListIterator<E> delegate;

        ConstrainedListIterator(ListIterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ListIterator<E> delegate() {
            return this.delegate;
        }

        @Override
        public void add(E element) {
            Preconditions.checkNotNull(element, "this list cannot contain null");
            this.delegate.add(element);
        }

        @Override
        public void set(E element) {
            Preconditions.checkNotNull(element, "this list cannot contain null");
            this.delegate.set(element);
        }
    }

    @GwtCompatible
    private static class ConstrainedList<E>
    extends ForwardingList<E> {
        final List<E> delegate;

        ConstrainedList(List<E> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected List<E> delegate() {
            return this.delegate;
        }

        @Override
        public boolean add(E element) {
            Preconditions.checkNotNull(element, "this list cannot contain null");
            return this.delegate.add(element);
        }

        @Override
        public void add(int index, E element) {
            Preconditions.checkNotNull(element, "this list cannot contain null");
            this.delegate.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            return this.delegate.addAll(ConstrainedMultimaps.checkElements(elements));
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> elements) {
            return this.delegate.addAll(index, ConstrainedMultimaps.checkElements(elements));
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ConstrainedListIterator<E>(this.delegate.listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ConstrainedListIterator<E>(this.delegate.listIterator(index));
        }

        @Override
        public E set(int index, E element) {
            Preconditions.checkNotNull(element, "this list cannot contain null");
            return this.delegate.set(index, element);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ConstrainedList<E>(this.delegate.subList(fromIndex, toIndex));
        }
    }

    private static class ConstrainedAsMapEntries<K, V>
    extends ForwardingSet<Map.Entry<K, Collection<V>>> {
        private final Set<Map.Entry<K, Collection<V>>> entries;

        ConstrainedAsMapEntries(Set<Map.Entry<K, Collection<V>>> entries) {
            this.entries = entries;
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> delegate() {
            return this.entries;
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return Iterators.transform(this.entries.iterator(), new Function<Map.Entry<K, Collection<V>>, Map.Entry<K, Collection<V>>>(this){

                @Override
                public Map.Entry<K, Collection<V>> apply(final Map.Entry<K, Collection<V>> entry) {
                    Preconditions.checkNotNull(entry);
                    return new ForwardingMapEntry<K, Collection<V>>(this){

                        @Override
                        protected Map.Entry<K, Collection<V>> delegate() {
                            return entry;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return new ConstrainedList((List)entry.getValue());
                        }
                    };
                }
            });
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }
    }

    private static class ConstrainedEntries<K, V>
    extends ForwardingCollection<Map.Entry<K, V>> {
        final Collection<Map.Entry<K, V>> entries;

        ConstrainedEntries(Collection<Map.Entry<K, V>> entries) {
            this.entries = entries;
        }

        @Override
        protected Collection<Map.Entry<K, V>> delegate() {
            return this.entries;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Iterators.transform(this.entries.iterator(), new Function<Map.Entry<K, V>, Map.Entry<K, V>>(this){

                @Override
                public Map.Entry<K, V> apply(final Map.Entry<K, V> entry) {
                    Preconditions.checkNotNull(entry);
                    return new ForwardingMapEntry<K, V>(this){

                        @Override
                        protected Map.Entry<K, V> delegate() {
                            return entry;
                        }

                        @Override
                        public V setValue(V value) {
                            Preconditions.checkNotNull(value, "null value in entry (%s, %s)", this.getKey(), value);
                            return entry.setValue(value);
                        }
                    };
                }
            });
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }
    }

    private static class ConstrainedAsMapValues<K, V>
    extends ForwardingCollection<Collection<V>> {
        final Collection<Collection<V>> delegate;
        final Set<Map.Entry<K, Collection<V>>> entrySet;

        ConstrainedAsMapValues(Collection<Collection<V>> delegate, Set<Map.Entry<K, Collection<V>>> entrySet) {
            this.delegate = delegate;
            this.entrySet = entrySet;
        }

        @Override
        protected Collection<Collection<V>> delegate() {
            return this.delegate;
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            final Iterator<Map.Entry<K, Collection<V>>> iterator = this.entrySet.iterator();
            return new Iterator<Collection<V>>(this){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Collection<V> next() {
                    return (Collection)((Map.Entry)iterator.next()).getValue();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        @Override
        public boolean contains(Object o) {
            return this.standardContains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.standardContainsAll(c);
        }

        @Override
        public boolean remove(Object o) {
            return this.standardRemove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.standardRemoveAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.standardRetainAll(c);
        }
    }

    private static class ConstrainedListMultimap<K, V>
    extends ForwardingListMultimap<K, V>
    implements ListMultimap<K, V>,
    Serializable {
        final ListMultimap<K, V> delegate;
        @LazyInit
        transient Collection<Map.Entry<K, V>> entries;
        @LazyInit
        transient Map<K, Collection<V>> asMap;

        ConstrainedListMultimap(ListMultimap<K, V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected ListMultimap<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public Map<K, Collection<V>> asMap() {
            class AsMap
            extends ForwardingMap<K, Collection<V>> {
                Set<Map.Entry<K, Collection<V>>> entrySet;
                Collection<Collection<V>> values;

                AsMap() {
                }

                @Override
                protected Map<K, Collection<V>> delegate() {
                    return asMapDelegate;
                }

                @Override
                public Set<Map.Entry<K, Collection<V>>> entrySet() {
                    Set result = this.entrySet;
                    if (result == null) {
                        this.entrySet = result = new ConstrainedAsMapEntries(asMapDelegate.entrySet());
                    }
                    return result;
                }

                @Override
                public Collection<V> get(Object key) {
                    try {
                        Collection collection = ConstrainedListMultimap.this.get(key);
                        return collection.isEmpty() ? null : collection;
                    }
                    catch (ClassCastException e) {
                        return null;
                    }
                }

                @Override
                public Collection<Collection<V>> values() {
                    Collection result = this.values;
                    if (result == null) {
                        this.values = result = new ConstrainedAsMapValues(this.delegate().values(), this.entrySet());
                    }
                    return result;
                }

                @Override
                public boolean containsValue(Object o) {
                    return this.values().contains(o);
                }
            }
            AsMap result = this.asMap;
            if (result == null) {
                final Map<K, Collection<V>> asMapDelegate = this.delegate.asMap();
                this.asMap = result = new AsMap();
            }
            return result;
        }

        @Override
        public Collection<Map.Entry<K, V>> entries() {
            Collection<Map.Entry<K, V>> result = this.entries;
            if (result == null) {
                this.entries = result = new ConstrainedEntries(this.delegate.entries());
            }
            return result;
        }

        @Override
        public List<V> get(K key) {
            return new ConstrainedList(this.delegate.get((Object)key));
        }

        @Override
        public boolean put(K key, V value) {
            Preconditions.checkNotNull(key, "null key in entry (%s, %s)", key, value);
            Preconditions.checkNotNull(value, "null value in entry (%s, %s)", key, value);
            return this.delegate.put(key, value);
        }

        @Override
        public boolean putAll(K key, Iterable<? extends V> values) {
            return this.delegate.putAll(key, ConstrainedMultimaps.checkValues(key, values));
        }

        @Override
        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            boolean changed = false;
            for (Map.Entry<K, V> entry : multimap.entries()) {
                changed |= this.put(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public List<V> replaceValues(K key, Iterable<? extends V> values) {
            return this.delegate.replaceValues((Object)key, (Iterable)ConstrainedMultimaps.checkValues(key, values));
        }
    }
}

