/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;

@GoogleInternal
@GwtCompatible
public final class GoogleHttpHeaders {
    public static final String X_CLIENT_DATA = "X-Client-Data";
    public static final String X_GZIP_CLIENT_DATA = "X-Gzip-Client-Data";
    public static final String X_GEO = "X-Geo";
    public static final String X_GOOGLE_BACKENDS = "X-Google-Backends";
    public static final String X_GOOGLE_CACHE_CONTROL = "X-Google-Cache-Control";
    public static final String X_GOOGLE_VARY = "X-Google-Vary";
    public static final String X_GOOGLE_COMMAND = "X-Google-Command";
    public static final String X_GOOGLE_COMPRESS_AGENT_FILTER = "X-Google-Compress-Agent-Filter";
    public static final String X_GOOGLE_COUNTRY = "X-Google-Country";
    public static final String X_GOOGLE_DAPPER_TRACE_INFO = "X-Google-DapperTraceInfo";
    public static final String X_GOOGLE_DEBUG = "X-Google-Debug";
    public static final String X_GOOGLE_EXPERIMENT = "X-Google-Experiment";
    public static final String X_GOOGLE_ABSOLUTE_EXPERIMENT = "X-Google-Absolute-Experiment";
    public static final String X_GOOGLE_CONDITIONAL_EXPERIMENT = "X-Google-Conditional-Experiment";
    public static final String X_GOOGLE_FROM_GMM_SERVER = "X-Google-From-Gmm-Server";
    public static final String X_GOOGLE_GFE_BACKEND_ID_FOR_LOGS = "X-Google-GFE-Backend-Id-For-Logs";
    public static final String X_GOOGLE_GFE_BACKEND_REQUEST_COST = "X-Google-GFE-Backend-Request-Cost";
    public static final String X_GOOGLE_GFE_BACKEND_REQUEST_INFO = "X-Google-GFE-Backend-Request-Info";
    public static final String X_GOOGLE_GFE_CACHED_RESPONSE_SIZE = "X-Google-GFE-CachedResponseSize";
    public static final String X_GOOGLE_GFE_CAN_REDIRECT = "X-Google-GFE-Can-Redirect";
    public static final String X_GOOGLE_GFE_CAN_RETRY = "X-Google-GFE-Can-Retry";
    public static final String X_GOOGLE_GFE_COMPRESS = "X-Google-GFE-Compress";
    public static final String X_GOOGLE_GFE_FRONTLINE_INFO = "X-Google-GFE-Frontline-Info";
    public static final String X_GOOGLE_GFE_INTERNAL_SERVICE_REDIRECT_DATA = "X-Google-GFE-Internal-Service-Redirect-Data";
    public static final String X_GOOGLE_GFE_KEEP_ORIGINAL_CONTENT_ENCODING = "X-Google-GFE-Keep-Original-Content-Encoding";
    public static final String X_GOOGLE_GFE_ORIGINAL_URL = "X-Google-GFE-Original-URL";
    public static final String X_GOOGLE_GFE_REQUEST_TRACE = "X-Google-GFE-Request-Trace";
    public static final String X_GOOGLE_GFE_SERVICE_TRACE = "X-Google-GFE-Service-Trace";
    public static final String X_GOOGLE_GFE_PREFERRED_URL = "X-Google-GFE-Preferred-URL";
    public static final String X_GOOGLE_GFE_UNTRUSTED_CONTENT_HOST = "X-Google-GFE-Untrusted-Content-Host";
    public static final String X_GOOGLE_GFE_UPGRADE = "X-Google-GFE-Upgrade";
    public static final String X_GOOGLE_GFE_CLOUD_CLIENT_VNID = "X-Google-GFE-Cloud-Client-VNID";
    public static final String X_GOOGLE_EES_REVERSE_TOKENIZATION = "X-Google-EES-ReverseTokenization";
    public static final String X_GOOGLE_EES_RT_AUTH_TOKEN = "X-Google-EES-RT-AuthToken";
    public static final String X_GOOGLE_EES_RT_SECURE_DATA_ESCAPING = "X-Google-EES-RT-Secure-Data-Escaping";
    public static final String X_GOOGLE_EES_SECURE_DATA_ID = "X-Google-EES-SecureDataId";
    public static final String X_GOOGLE_EES_SECURE_DATA_TYPE = "X-Google-EES-SecureDataType";
    public static final String X_GOOGLE_GMM_EXPERIMENT_IDS = "X-Google-Gmm-Experiment-Ids";
    public static final String X_GOOGLE_GMM_DOGFOOD = "X-Google-Gmm-Dogfood";
    public static final String X_GOOGLE_GMM_CLIENT = "X-Google-Gmm-Client";
    public static final String X_GOOGLE_GSE_SKIP_HEALTH_CHECKING = "X-Google-GSE-Skip-Health-Checking";
    public static final String X_GOOGLE_NETMON_LABEL = "X-Google-Netmon-Label";
    public static final String X_GOOGLE_PLOGS_STRATEGY = "X-Google-Plogs-Strategy";
    public static final String X_GOOGLE_REQUEST_UID = "X-Google-Request-UID";
    public static final String X_GOOGLE_SERVER_TYPE = "X-Google-ServerType";
    public static final String X_GOOGLE_SERVICE = "X-Google-Service";
    public static final String X_GOOGLE_TRACE = "X-Google-Trace";
    public static final String X_CLOUD_TRACE_CONTEXT = "X-Cloud-Trace-Context";
    public static final String TRACE_CONTEXT = "Trace-Context";
    public static final String X_GOOGLE_CLOUD_TRACE_PARENT = "X-Google-Cloud-Trace-Parent";
    public static final String X_GOOGLE_CLOUD_SPAN_SAMPLED = "X-Google-Cloud-Span-Sampled";
    public static final String X_GOOGLE_SESSION_INFO = "X-Google-Session-Info";
    public static final String X_GFE_SSL = "X-GFE-SSL";
    public static final String X_GFE_SSL_CERTIFICATE = "X-GFE-SSL-Certificate";
    public static final String X_GFE_TLS_CHANNEL_ID = "X-GFE-TLS-ChannelID";
    public static final String X_GPROXY_RESTRICT = "X-GProxy-Restrict";
    public static final String X_GPROXY_COUNTRY = "X-GProxy-Country";
    public static final String X_PROXIED_USER_IP = "X-Proxied-User-IP";
    public static final String X_GOOGLE_GWS_TOOLS = "X-Google-GWS-Tools";
    public static final String X_GSA_DOC_CONTROLS = "X-Gsa-Doc-Controls";
    public static final String X_GSA_PRELOADED_PAGE_CONTENT_TYPE = "X-Gsa-Preloaded-Page-Content-Type";
    public static final String X_GSA_PRELOADED_PAGE_CONTEXT = "X-Gsa-Preloaded-Page-Context";
    public static final String X_GSA_SKIP_UPDATING_CONTENT = "X-Gsa-Skip-Updating-Content";
    public static final String X_CLIENT_DISCOURSE_CONTEXT = "X-Client-Discourse-Context";
    public static final String X_ADDITIONAL_DISCOURSE_CONTEXT = "X-Additional-Discourse-Context";
    public static final String X_HOMESCREEN_WIDGET_SIZE = "X-Homescreen-Widget-Size";
    public static final String X_ASSISTANT_CAPABILITIES = "X-Assistant-Capabilities";
    public static final String X_ASSISTANT_DEVICE_CAPABILITIES = "X-Assistant-Device-Capabilities";
    public static final String X_ASSISTANT_DEVICE_VISIBLE_DATA = "X-Assistant-Device-Visible-Data";
    public static final String X_ASSISTANT_SETTINGS = "X-Assistant-Settings";
    public static final String X_ASSISTANT_SEARCH_REQUEST_DATA = "X-Assistant-Search-Request-Data";
    public static final String X_ASSISTANT_USER_TYPE = "X-Assistant-User-Type";
    public static final String X_ASSISTANT_SURFACE = "X-Assistant-Surface";
    public static final String X_ASSISTANT_ENTRY_SOURCE = "X-Assistant-Entry-Source";
    public static final String X_CLIENT_OPT_IN_CONTEXT = "X-Client-Opt-In-Context";
    public static final String X_CLIENT_INSTANCE_ID = "X-Client-Instance-Id";
    public static final String X_DEVICE_ELAPSED_TIME = "X-Device-Elapsed-Time";
    public static final String X_DEVICE_BOOT_COUNT = "X-Device-Boot-Count";
    public static final String X_GOOGLE_PRIVACY_MODIFIERS = "X-Google-Privacy-Modifiers";
    public static final String X_GOOGLE_PRIVACY_INFO = "X-Google-Privacy-Info";
    public static final String X_GOOGLE_UPGRADE_INTERNAL_COOKIE_FILTERING = "X-Google-Upgrade-Internal-Cookie-Filtering";
    public static final String X_GOOGLE_OVERRIDE_COOKIE_FILTER_MODE = "X-Google-Override-Cookie-Filter-Mode";
    public static final String X_GOOGLE_COOKIE_FILTER_TENANT_NAME = "X-Google-Cookie-Filter-Tenant-Name";
    public static final String X_GOOGLE_CONSENT_BUMP = "X-Google-Consent-Bump";
    public static final String X_GOOGLE_CONSENT_BUMP_REGION_CODE = "X-Google-Consent-Bump-Region-Code";
    public static final String X_GOOGLE_GWSDIFF_LOG_PROTO = "X-Google-Gwsdiff-Log-Proto";
    public static final String X_SPEECH_REQUESTID = "X-Speech-Requestid";
    public static final String X_GOOGLE_SPEECH_RECOGNITION_RESULT = "X-Google-Speech-Recognition-Result";
    public static final String X_GOOGLE_SPEECH_EXPERIMENTS = "X-Google-Speech-Experiments";
    public static final String X_GOOGLE_APPS_FRAMEWORK_ACTION = "X-Google-Apps-Framework-Action";
    public static final String X_DEVICE_FAMILY = "X-Device-Family";
    public static final String X_SILENT_REDIRECT = "X-Silent-Redirect";
    public static final String X_GOOGLE_CLICK_SERVERS_INFO = "X-Google-Click-Servers-Info";
    public static final String X_GOOGLE_VIEW_SERVERS_INFO = "X-Google-View-Servers-Info";
    public static final String X_GOOGLE_REQUEST_ID = "X-Google-Request-Id";
    public static final String X_GR = "X-Gr";
    public static final String X_DONT_COUNT_ADS = "X-Dont-Count-Ads";
    public static final String X_DONT_SHOW_ADS = "X-Dont-Show-Ads";
    public static final String X_GOOGLE_FROM_UHURA = "X-Google-From-Uhura";
    public static final String X_GOOGLE_UHURA_CLIENT_NAME = "X-Google-Uhura-Client-Name";
    public static final String X_GOOGLE_UHURA_CLIENT_TYPE = "X-Google-Uhura-Client-Type";
    public static final String X_IDENTITY_OAUTH2_DEVICE_USERCODE = "X-Identity-Oauth2-Device-Usercode";
    public static final String X_MOTHERSHIP_SEARCH_API_CLIENT = "X-Mothership-Search-Api-Client";
    public static final String X_GOOGLE_MOTHERSHIP_SEARCH_API_SEARCH_MASK = "X-Google-Mothership-Search-Api-Search-Mask";
    public static final String X_GOOGLE_MOTHERSHIP_REQUEST_TOKEN_AUTHENTICATORS = "X-Google-Mothership-Request-Token-Authenticators";
    public static final String X_GOOGLE_USE_GEOLOCATION_FOR_COUNTRY_CODE = "X-Google-Use-Geolocation-For-Country-Code";
    public static final String X_BOT_GROUP_ID = "X-Bot-Group-ID";
    public static final String X_GCS_REDIRECT = "X-GCS-Redirect";
    public static final String X_AUDIT = "X-Audit";
    public static final String X_AFMA_DRT_COOKIE = "X-Afma-Drt-Cookie";
    public static final String X_UCBROWSER_DEVICE_UA = "X-UCBrowser-Device-UA";
    public static final String X_UCBROWSER_UA = "X-UCBrowser-UA";
    public static final String CHROME_PROXY = "Chrome-Proxy";
    public static final String CHROME_PROXY_ECT = "Chrome-Proxy-Ect";
    public static final String CHROME_PROXY_ACCEPT_TRANSFORM = "Chrome-Proxy-Accept-Transform";
    public static final String X_GOOGLE_ENDUSERCREDS = "X-Google-EndUserCreds";
    public static final String X_GOOGLE_SECURITY_SIGNALS = "X-Google-Security-Signals";
    public static final String X_SERVER_SIDE_HASH = "X-Server-Side-Hash";
    public static final String X_GOOGLE_OVERRIDE_LOCALE = "X-Google-Override-Locale";
    public static final String X_GOOGLE_CHARGEABLE_INTERNAL_SERVICE = "X-Google-Chargeable-Internal-Service";
    public static final String X_CLIENTTOKEN_REQUEST = "X-Clienttoken-Request";
    public static final String X_CLIENTTOKEN = "X-Clienttoken";
    @VisibleForTesting
    static final ImmutableSet<String> INTERNAL_NON_X_GOOGLE_HEADERS = ImmutableSet.of("X-Dont-Count-Ads", "X-Dont-Show-Ads", "X-Google-Request-Id", "X-Gr", "X-GProxy-Country", "X-GProxy-Restrict", new String[]{"X-User-IP"});

    private GoogleHttpHeaders() {
    }

    public static boolean isGoogleInternalHeader(String header) {
        for (String specialHeader : INTERNAL_NON_X_GOOGLE_HEADERS) {
            if (!Ascii.equalsIgnoreCase(header, specialHeader)) continue;
            return true;
        }
        return Ascii.toLowerCase(header).startsWith("x-google");
    }

    public static final class XGoogleCommandValues {
        public static final String DRAIN_SESSIONS = "Drain-Sessions";
        public static final String GFE_CACHE_FLUSH = "gfe_cache_flush";
        public static final String GFE_LOGGING_REQUEST = "gfe_logging_request";
        public static final String IGNORE_500 = "Ignore500";
        public static final String INTERNAL_REDIRECT = "InternalRedirect";
        public static final String GRPC_INTERNAL_REDIRECT = "GrpcInternalRedirect";
        public static final String RETRY = "retry";

        private XGoogleCommandValues() {
        }
    }
}

