/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.common.net.PercentEscaper;

@GoogleInternal
@GwtIncompatible
public final class HttpHeaderEscapers {
    private static final PercentEscaper RFC_5987_ESCAPER = new PercentEscaper("!#$&+-.^_`|~", false);
    private static final Escaper QUOTED_ASCII_ESCAPER = Escapers.builder().setSafeRange(' ', '~').setUnsafeReplacement("_").addEscape('\\', "\\\\").addEscape('\"', "\\\"").build();

    private HttpHeaderEscapers() {
    }

    public static Escaper rfc5987Escaper() {
        return RFC_5987_ESCAPER;
    }

    public static Escaper quotedAsciiEscaper() {
        return QUOTED_ASCII_ESCAPER;
    }
}

