/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;

@GwtCompatible
@GoogleInternal
public final class LegacyUrlEscapers {
    public static final String URL_FORM_PARAMETER_OTHER_SAFE_CHARS = "-_.*";
    private static final Escaper URL_FORM_PARAMETER_ESCAPER_LACKING_PLUS = new PercentEscaper("-_.*", false);
    public static final String URL_PATH_OTHER_SAFE_CHARS_LACKING_PLUS = "-._~!$'()*,;&=@:";
    private static final Escaper URL_PATH_SEGMENT_ESCAPER_REDUNDANT_PLUS_ESCAPING = new PercentEscaper("-._~!$'()*,;&=@:", false);
    public static final String UNDERESCAPING_URL_FORM_PARAMETER_SAFE_CHARS = "-._~!$'()*,;@:/?";
    private static final Escaper UNDERESCAPING_URL_FORM_PARAMETER_ESCAPER = new PercentEscaper("-._~!$'()*,;@:/?", true);
    private static final Escaper UNDERESCAPING_URL_FORM_PARAMETER_ESCAPER_LACKING_PLUS = new PercentEscaper("-._~!$'()*,;@:/?", false);
    private static final String ALL_VALID_URL_CHARS = "-._~:/?#[]@!$&'()*+,;=%";
    static final Escaper UNDERESCAPED_URL_ESCAPER = new PercentEscaper("-._~:/?#[]@!$&'()*+,;=%", false);
    @GoogleInternal
    private static final Escaper UNDERESCAPING_CPP_URL_FORM_PARAMETER_ESCAPER = new PercentEscaper("!()*-._~,/:", true);

    private LegacyUrlEscapers() {
    }

    public static Escaper urlFormParameterEscaperLackingPlus() {
        return URL_FORM_PARAMETER_ESCAPER_LACKING_PLUS;
    }

    public static Escaper urlPathSegmentEscaperRedundantPlusEscaping() {
        return URL_PATH_SEGMENT_ESCAPER_REDUNDANT_PLUS_ESCAPING;
    }

    public static Escaper underescapingUrlFormParameterEscaper() {
        return UNDERESCAPING_URL_FORM_PARAMETER_ESCAPER;
    }

    public static Escaper underescapingUrlFormParameterEscaperLackingPlus() {
        return UNDERESCAPING_URL_FORM_PARAMETER_ESCAPER_LACKING_PLUS;
    }

    public static String mungeUnderescapedUrl(String url) {
        return UNDERESCAPED_URL_ESCAPER.escape(url);
    }

    @GoogleInternal
    public static Escaper underescapingCppUrlFormParameterEscaper() {
        return UNDERESCAPING_CPP_URL_FORM_PARAMETER_ESCAPER;
    }
}

