/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@GoogleInternal
@GwtCompatible
public final class MediaTypeSelector
implements Function<MediaType, MediaType> {
    private static final MediaTypeSelector DEFAULT_SELECTOR = new MediaTypeSelector(new ImmutableMap.Builder<MediaType, MediaType>().put(MediaType.TEXT_JAVASCRIPT_UTF_8.withoutParameters(), MediaType.JAVASCRIPT_UTF_8.withoutParameters()).put(MediaType.createApplicationType("rar"), MediaType.RAR).put(MediaType.createApplicationType("x-pdf"), MediaType.PDF).put(MediaType.createImageType("x-photoshop"), MediaType.PSD).put(MediaType.createApplicationType("x-vnd.oasis.opendocument.graphics"), MediaType.OPENDOCUMENT_GRAPHICS).put(MediaType.createApplicationType("x-vnd.oasis.opendocument.presentation"), MediaType.OPENDOCUMENT_PRESENTATION).put(MediaType.createApplicationType("x-vnd.oasis.opendocument.spreadsheet"), MediaType.OPENDOCUMENT_SPREADSHEET).put(MediaType.createApplicationType("x-vnd.oasis.opendocument.text"), MediaType.OPENDOCUMENT_TEXT).put(MediaType.createTextType(MediaType.RTF_UTF_8.subtype()), MediaType.RTF_UTF_8.withoutParameters()).build());
    private static final Joiner REPLACEMENT_CHAIN_JOINER = Joiner.on(" -> ");
    private final ImmutableMap<MediaType, MediaType> replacements;

    public static MediaTypeSelector defaultInstance() {
        return DEFAULT_SELECTOR;
    }

    @VisibleForTesting
    MediaTypeSelector(ImmutableMap<MediaType, MediaType> replacements) {
        ImmutableMap.Builder<MediaType, MediaType> builder = ImmutableMap.builder();
        for (Map.Entry entry : replacements.entrySet()) {
            MediaType replaced = (MediaType)entry.getKey();
            Preconditions.checkArgument(replaced.parameters().isEmpty(), "%s must be specified without parameters", (Object)replaced);
            ArrayList<MediaType> replacementChain = Lists.newArrayList(replaced);
            @Nullable MediaType replacement = (MediaType)entry.getValue();
            Preconditions.checkArgument(replacement.parameters().isEmpty(), "%s must be specified without parameters", (Object)replacement);
            while (replacement != null) {
                replacementChain.add(replacement);
                if (replaced.equals(replacement)) {
                    StringBuilder exceptionStringBuilder = new StringBuilder("a cycle has been detected in the replacements: ");
                    REPLACEMENT_CHAIN_JOINER.appendTo(exceptionStringBuilder, (Iterable<?>)replacementChain);
                    throw new IllegalArgumentException(exceptionStringBuilder.toString());
                }
                replacement = replacements.get(replacement);
            }
            builder.put(replaced, Iterables.getLast(replacementChain));
        }
        this.replacements = builder.build();
    }

    public MediaType select(MediaType mediaType) {
        @Nullable MediaType preferredMediaType = this.replacements.get(mediaType.withoutParameters());
        return preferredMediaType == null ? mediaType : preferredMediaType.withParameters(mediaType.parameters());
    }

    @Override
    @Deprecated
    public MediaType apply(MediaType input) {
        return this.select(input);
    }

    @CheckReturnValue
    public MediaTypeSelector withReplacement(MediaType mediaType, MediaType replacement) {
        return this.withReplacements(ImmutableMap.of(mediaType, replacement));
    }

    @CheckReturnValue
    public MediaTypeSelector withReplacements(final Map<MediaType, MediaType> replacements) {
        return new MediaTypeSelector(new ImmutableMap.Builder<MediaType, MediaType>().putAll(replacements).putAll(Maps.filterEntries(this.replacements, new Predicate<Map.Entry<MediaType, MediaType>>(this){

            @Override
            public boolean apply(Map.Entry<MediaType, MediaType> input) {
                return !replacements.containsKey(input.getKey()) && !input.getKey().equals(replacements.get(input.getValue()));
            }
        })).build());
    }

    @CheckReturnValue
    public MediaTypeSelector withoutReplacement(MediaType mediaType) {
        Preconditions.checkNotNull(mediaType);
        Preconditions.checkArgument(mediaType.parameters().isEmpty());
        return new MediaTypeSelector(ImmutableMap.copyOf(Maps.filterKeys(this.replacements, Predicates.not(Predicates.equalTo(mediaType.withoutParameters())))));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("replacements", this.replacements).toString();
    }
}

