/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.net.InternetDomainName;
import com.google.common.net.Uri;
import com.google.common.net.UriBuilder;
import com.google.common.net.UriEncoder;
import com.google.common.net.UriParameterMap;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GoogleInternal
@GwtCompatible(emulated=true)
final class Platform {
    private static final Pattern AUTHORITY_WITH_NAMED_HOST_PATTERN = Pattern.compile("(?:.*?@)?([^:]+)(?::\\d+)?");

    private Platform() {
    }

    static UriParameterMap uriParameterMapParse(String query) {
        return UriParameterMap.parse(query, UriEncoder.DEFAULT_ENCODING);
    }

    static UriParameterMap uriParameterMapParse(String query, Charset encoding) {
        return UriParameterMap.parse(query, encoding);
    }

    static String uriParameterMapToString(UriParameterMap uriParameterMap) {
        return uriParameterMap.toString(UriEncoder.DEFAULT_ENCODING);
    }

    static String uriParameterMapToString(UriParameterMap uriParameterMap, Charset encoding) {
        Preconditions.checkNotNull(encoding);
        return uriParameterMap.toString(encoding);
    }

    static Uri uriParse(String uriString) {
        return Uri.parse(uriString, UriEncoder.DEFAULT_ENCODING);
    }

    static UriParameterMap uriParseQueryString(Uri uri, String query) {
        return UriParameterMap.parse(query, uri.getEncoding());
    }

    static UriBuilder uriBuilder(Charset encoding) {
        return new UriBuilder(encoding);
    }

    static InternetDomainName uriGetDomain(Uri uri) {
        Matcher matcher = AUTHORITY_WITH_NAMED_HOST_PATTERN.matcher(uri.getAuthority());
        if (matcher.matches()) {
            String host = matcher.group(1);
            try {
                return InternetDomainName.from(host);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.format("Invalid domain '%s' found in URI '%s'", host, uri), e);
            }
        }
        String string = String.valueOf(uri);
        throw new IllegalStateException(new StringBuilder(37 + String.valueOf(string).length()).append("Authority doesn't match web pattern: ").append(string).toString());
    }

    static String asciiToLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    static void checkUriEncoding(Uri uri) {
        Preconditions.checkArgument(uri.getEncoding().equals(UriEncoder.DEFAULT_ENCODING), "Refusing to serialize URI [%s] with encoding [%s]; only UTF-8 is supported by GWT client code.", (Object)uri, (Object)uri.getEncoding());
    }
}

