/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.google.common.net.Platform;
import com.google.common.net.UriEncoder;
import com.google.common.net.UriParameterMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
@GoogleInternal
public final class Uri
implements Comparable<Uri>,
Serializable {
    private static final long serialVersionUID = -1105194233979842380L;
    @GwtIncompatible
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/\\\\?#]+):)?(//([^/\\\\?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?", 32);
    private final String scheme;
    private final String authority;
    private final String path;
    private final String query;
    private final String fragment;
    private transient Charset encoding;
    private volatile transient UriParameterMap queryParameters;
    private volatile transient String string;

    Uri(String scheme, String authority, String path, String query, String fragment, Charset encoding) {
        this.scheme = Uri.normalizeScheme(scheme);
        this.authority = authority;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
        this.encoding = encoding;
    }

    public static Uri parse(String uri) {
        return Platform.uriParse(uri);
    }

    @GwtIncompatible
    public static Uri parse(String uri, Charset encoding) {
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(encoding);
        Matcher matcher = URI_PATTERN.matcher(uri);
        Preconditions.checkState(matcher.matches(), "Internal error for URI: %s", (Object)uri);
        String scheme = matcher.group(2);
        String authority = matcher.group(4);
        String path = Strings.emptyToNull(matcher.group(5));
        String query = matcher.group(7);
        String fragment = matcher.group(9);
        return new Uri(scheme, authority, path, query, fragment, encoding);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAuthority() {
        return this.authority;
    }

    public InternetDomainName getDomain() {
        Preconditions.checkState(!Strings.isNullOrEmpty(this.authority), "Uri has no authority: %s", (Object)this);
        return Platform.uriGetDomain(this);
    }

    @GwtIncompatible
    public InetAddress getIpAddress() {
        try {
            return InetAddresses.forString(this.getHostAndPort().getHost());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Invalid IP address '%s' found in URI '%s'", this.authority, this), e);
        }
    }

    public HostAndPort getHostAndPort() {
        Preconditions.checkState(!Strings.isNullOrEmpty(this.authority), "Uri has no authority: %s", (Object)this);
        int credentialEnd = this.authority.indexOf("@");
        String hostAndPortString = credentialEnd < 0 ? this.authority : this.authority.substring(credentialEnd + 1);
        try {
            return HostAndPort.fromString(hostAndPortString).requireBracketsForIPv6();
        }
        catch (IllegalArgumentException e) {
            String string = this.authority;
            String string2 = String.valueOf(this);
            throw new IllegalStateException(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid authority '").append(string).append("' found in URI '").append(string2).append("'").toString(), e);
        }
    }

    @GwtIncompatible
    public boolean hasValidDomainOrIpAddress() {
        try {
            this.getDomain();
            return true;
        }
        catch (IllegalStateException e) {
            try {
                this.getIpAddress();
                return true;
            }
            catch (IllegalStateException e2) {
                return false;
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public UriParameterMap getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = this.query == null ? UriParameterMap.EMPTY_MAP : UriParameterMap.unmodifiableMap(Platform.uriParseQueryString(this, this.query));
        }
        return this.queryParameters;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @GwtIncompatible
    public String decodePercent(@Nullable String value) {
        return value == null ? null : UriEncoder.lenientDecode(value, this.encoding, false);
    }

    @Override
    public int compareTo(Uri other) {
        Preconditions.checkNotNull(other);
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Uri)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.string == null) {
            int length = 0;
            if (this.scheme != null) {
                length += this.scheme.length() + 1;
            }
            if (this.authority != null) {
                length += 2 + this.authority.length();
            }
            if (this.path != null) {
                length += this.path.length();
            }
            if (this.query != null) {
                length += 1 + this.query.length();
            }
            if (this.fragment != null) {
                length += 1 + this.fragment.length();
            }
            StringBuilder out = new StringBuilder(length);
            if (this.scheme != null) {
                out.append(this.scheme).append(':');
            }
            if (this.authority != null) {
                out.append("//").append(this.authority);
            }
            if (this.path != null) {
                out.append(this.path);
            }
            if (this.query != null) {
                out.append('?').append(this.query);
            }
            if (this.fragment != null) {
                out.append('#').append(this.fragment);
            }
            this.string = out.toString();
        }
        return this.string;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.encoding.name());
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String charset = (String)ois.readObject();
        this.encoding = Charset.forName(charset);
    }

    private static String normalizeScheme(@Nullable String scheme) {
        return scheme == null ? null : Platform.asciiToLowerCase(scheme);
    }

    @GwtIncompatible
    public List<String> getPathSegments() {
        ArrayList<String> result = new ArrayList<String>();
        if (Strings.isNullOrEmpty(this.path)) {
            result.add("");
            return result;
        }
        List<String> segments = Splitter.on('/').splitToList(this.path);
        if ("".equals(segments.get(0))) {
            segments = segments.subList(1, segments.size());
        }
        for (String segment : segments) {
            result.add(UriEncoder.lenientDecode(segment, this.encoding, false));
        }
        return result;
    }
}

