/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.net.Platform;
import com.google.common.net.Uri;
import com.google.common.net.UriEncoder;
import com.google.common.net.UriParameterMap;
import com.google.common.net.UriScheme;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=false, emulated=true)
@GoogleInternal
public final class UriBuilder
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8238943980617262692L;
    private final Charset encoding;
    private String scheme;
    private String authority;
    private String path;
    private UriParameterMap queryParameters;
    private String fragment;

    public UriBuilder() {
        this.encoding = UriEncoder.DEFAULT_ENCODING;
    }

    @GwtIncompatible
    public UriBuilder(Charset encoding) {
        Preconditions.checkNotNull(encoding);
        this.encoding = encoding;
    }

    public static UriBuilder of(Uri uri) {
        Preconditions.checkNotNull(uri);
        return Platform.uriBuilder(uri.getEncoding()).merge(uri);
    }

    public static UriBuilder parse(String uri) {
        return UriBuilder.of(Uri.parse(uri));
    }

    @GwtIncompatible
    public static UriBuilder parse(String uri, Charset encoding) {
        return UriBuilder.of(Uri.parse(uri, encoding));
    }

    public UriBuilder clone() {
        UriBuilder clone = new UriBuilder();
        if (this.scheme != null) {
            clone.setScheme(this.scheme);
        }
        if (this.authority != null) {
            clone.setAuthority(this.authority);
        }
        if (this.path != null) {
            clone.setPath(this.path);
        }
        if (this.fragment != null) {
            clone.setFragment(this.fragment);
        }
        if (this.queryParameters != null) {
            clone.queryParameters = this.queryParameters.clone();
        }
        return clone;
    }

    public UriBuilder merge(Uri uri) {
        Preconditions.checkNotNull(uri);
        Preconditions.checkArgument(this.encoding.equals(uri.getEncoding()), "encoding mismatch; expected %s but was %s", (Object)this.encoding, (Object)uri.getEncoding());
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getAuthority() != null) {
            this.authority = uri.getAuthority();
        }
        if (uri.getPath() != null) {
            this.path = uri.getPath();
        }
        if (!uri.getQueryParameters().isEmpty()) {
            this.getQueryParameters().putAll(uri.getQueryParameters());
        }
        if (uri.getFragment() != null) {
            this.fragment = uri.getFragment();
        }
        return this;
    }

    public UriBuilder setScheme(@Nullable String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UriBuilder setUriScheme(@Nullable UriScheme scheme) {
        return this.setScheme(scheme == null ? null : scheme.toString());
    }

    public String getScheme() {
        return this.scheme;
    }

    public UriBuilder setAuthority(@Nullable String authority) {
        this.authority = authority;
        return this;
    }

    public String getAuthority() {
        return this.authority;
    }

    public UriBuilder setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UriBuilder setQuery(@Nullable String query) {
        if (this.queryParameters != null) {
            this.queryParameters.clear();
        }
        if (query != null && !query.isEmpty()) {
            this.getQueryParameters().merge(Platform.uriParameterMapParse(query, this.encoding));
        }
        return this;
    }

    public String getQuery() {
        if (this.queryParameters == null || this.queryParameters.isEmpty()) {
            return null;
        }
        return Platform.uriParameterMapToString(this.queryParameters, this.encoding);
    }

    public UriBuilder addQueryParameter(String name, String value) {
        this.getQueryParameters().put(name, value);
        return this;
    }

    public UriBuilder replaceQueryParameters(String name, String ... values) {
        Preconditions.checkNotNull(name);
        this.getQueryParameters().replaceValues(name, Arrays.asList(values));
        return this;
    }

    public UriParameterMap getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new UriParameterMap();
        }
        return this.queryParameters;
    }

    public UriBuilder setFragment(@Nullable String fragment) {
        this.fragment = fragment;
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Uri getUri() {
        return new Uri(this.scheme, this.authority, this.path, this.getQuery(), this.fragment, this.encoding);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @Deprecated
    public String encode(@Nullable String value) {
        return value == null ? null : UriEncoder.encode(value, this.encoding);
    }

    @Deprecated
    public String decode(@Nullable String value) {
        return value == null ? null : UriEncoder.decode(value, this.encoding);
    }

    public String toString() {
        return this.getUri().toString();
    }
}

