/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.flags.Flag;
import com.google.common.flags.FlagSpec;
import com.google.common.net.LegacyUrlEscapers;
import com.google.common.net.UrlEscapers;
import com.google.common.primitives.UnsignedBytes;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;

@GwtCompatible(emulated=true)
@GoogleInternal
public final class UriEncoder {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @FlagSpec(help="Which characters UriEncoder and related classes should escape in query parameters. Options are limited to predefined sets.", name="query_parameter_escape_policy")
    @Deprecated
    @GwtIncompatible
    public static final Flag<QueryParameterEscapePolicy> escapePolicy = Flag.value(QueryParameterEscapePolicy.LEGACY_UNDERESCAPING);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final CharMatcher SAFE_OCTETS_MATCHER = CharMatcher.anyOf("-_.*").or(CharMatcher.inRange('0', '9')).or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.inRange('a', 'z'));
    public static final Charset DEFAULT_ENCODING = UTF_8;

    private UriEncoder() {
    }

    public static String encode(String string) {
        return escapePolicy.get().getEscaper().escape(string);
    }

    @GwtIncompatible
    public static String encode(String string, Charset encoding) {
        return encoding.equals(DEFAULT_ENCODING) ? UriEncoder.encode(string) : UriEncoder.fastEncode(string, encoding);
    }

    @GwtIncompatible
    @VisibleForTesting
    static String fastEncode(String string, Charset encoding) {
        StringBuilder out = new StringBuilder(string.length() * 2);
        byte[] data = string.getBytes(encoding);
        boolean containsSpace = false;
        int outputLength = 0;
        for (byte b : data) {
            int c = UnsignedBytes.toInt(b);
            if (SAFE_OCTETS_MATCHER.matches((char)c)) {
                out.append((char)c);
                ++outputLength;
                continue;
            }
            if (c == 32) {
                containsSpace = true;
                out.append('+');
                ++outputLength;
                continue;
            }
            out.append('%');
            out.append(HEX_DIGITS[c >> 4]);
            out.append(HEX_DIGITS[c & 0xF]);
            outputLength += 3;
        }
        return containsSpace || outputLength != string.length() ? out.toString() : string;
    }

    public static String decode(String string) {
        return UriEncoder.decode(string, DEFAULT_ENCODING);
    }

    @GwtIncompatible
    public static String decode(String string, Charset encoding) {
        try {
            return URLDecoder.decode(string, encoding.name());
        }
        catch (UnsupportedEncodingException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    @GwtIncompatible
    public static String lenientDecode(String string, Charset encoding, boolean decodePlus) {
        int firstPercentPos;
        Preconditions.checkNotNull(string);
        Preconditions.checkNotNull(encoding);
        if (decodePlus) {
            string = string.replace('+', ' ');
        }
        if ((firstPercentPos = string.indexOf(37)) < 0) {
            return string;
        }
        ByteAccumulator accumulator = new ByteAccumulator(string.length(), encoding);
        StringBuilder builder = new StringBuilder(string.length());
        if (firstPercentPos > 0) {
            builder.append(string, 0, firstPercentPos);
        }
        for (int srcPos = firstPercentPos; srcPos < string.length(); ++srcPos) {
            char c = string.charAt(srcPos);
            if (c < '\u0080') {
                boolean processed = false;
                if (c == '%' && string.length() >= srcPos + 3) {
                    String hex = string.substring(srcPos + 1, srcPos + 3);
                    try {
                        int encoded = Integer.parseInt(hex, 16);
                        if (encoded >= 0) {
                            accumulator.append((byte)encoded);
                            srcPos += 2;
                            processed = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (processed) continue;
                if (accumulator.isEmpty()) {
                    builder.append(c);
                    continue;
                }
                accumulator.append((byte)c);
                continue;
            }
            accumulator.dumpTo(builder);
            builder.append(c);
        }
        accumulator.dumpTo(builder);
        return builder.toString();
    }

    @GwtIncompatible
    private static class ByteAccumulator {
        private byte[] bytes;
        private int length;
        private final Charset encoding;

        ByteAccumulator(int capacity, Charset encoding) {
            this.bytes = new byte[Math.min(16, capacity)];
            this.encoding = encoding;
        }

        void append(byte b) {
            this.ensureCapacity(this.length + 1);
            this.bytes[this.length++] = b;
        }

        void dumpTo(StringBuilder dest) {
            if (this.length != 0) {
                dest.append(new String(this.bytes, 0, this.length, this.encoding));
                this.length = 0;
            }
        }

        boolean isEmpty() {
            return this.length == 0;
        }

        private void ensureCapacity(int minCapacity) {
            int cap = this.bytes.length;
            if (cap >= minCapacity) {
                return;
            }
            int newCapacity = cap + (cap >> 1);
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }

    @GwtIncompatible
    public static enum QueryParameterEscapePolicy {
        CPP_EMULATED_UNDERESCAPING,
        LEGACY_UNDERESCAPING,
        SPEC_COMPLIANT_ESCAPING;


        Escaper getEscaper() {
            switch (this) {
                case CPP_EMULATED_UNDERESCAPING: {
                    return LegacyUrlEscapers.underescapingCppUrlFormParameterEscaper();
                }
                case LEGACY_UNDERESCAPING: {
                    return LegacyUrlEscapers.underescapingUrlFormParameterEscaper();
                }
                case SPEC_COMPLIANT_ESCAPING: {
                    return UrlEscapers.urlFormParameterEscaper();
                }
            }
            throw new AssertionError();
        }
    }
}

