/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.net.ConstrainedMultimaps;
import com.google.common.net.Platform;
import com.google.common.net.UriEncoder;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@GwtCompatible(emulated=true)
@GoogleInternal
public final class UriParameterMap
extends ForwardingListMultimap<String, String>
implements Cloneable,
Serializable {
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final UriParameterMap EMPTY_MAP = new UriParameterMap(ImmutableListMultimap.of());
    private final ListMultimap<String, String> delegate;
    private static final long serialVersionUID = -3053773769157973706L;

    private UriParameterMap(ListMultimap<String, String> delegate) {
        this.delegate = ConstrainedMultimaps.nullRejectingListMultimap(delegate);
    }

    public UriParameterMap() {
        this(LinkedListMultimap.create());
    }

    public static UriParameterMap parse(String query) {
        return Platform.uriParameterMapParse(query);
    }

    @GwtIncompatible
    public static UriParameterMap parse(String query, Charset encoding) {
        Preconditions.checkNotNull(query);
        Preconditions.checkNotNull(encoding);
        UriParameterMap map = new UriParameterMap();
        if (!query.isEmpty()) {
            int start = 0;
            boolean requiresByteLevelDecoding = UriParameterMap.requiresByteLevelDecoding(encoding);
            while (start <= query.length()) {
                int equalsIndex;
                int ampersandIndex = query.indexOf(38, start);
                if (ampersandIndex == -1) {
                    ampersandIndex = query.length();
                }
                if ((equalsIndex = query.indexOf(61, start)) > ampersandIndex) {
                    equalsIndex = -1;
                }
                int paramNameEndIndex = equalsIndex == -1 ? ampersandIndex : equalsIndex;
                String name = UriParameterMap.decodeString(query, start, paramNameEndIndex, encoding, requiresByteLevelDecoding);
                String value = equalsIndex == -1 ? "" : UriParameterMap.decodeString(query, equalsIndex + 1, ampersandIndex, encoding, requiresByteLevelDecoding);
                map.put(name, value);
                start = ampersandIndex + 1;
            }
        }
        return map;
    }

    public static UriParameterMap copyOf(Multimap<String, String> map) {
        Preconditions.checkNotNull(map);
        UriParameterMap paramMap = new UriParameterMap();
        paramMap.putAll(map);
        return paramMap;
    }

    public static UriParameterMap fromArrayMap(Map<String, String[]> map) {
        Preconditions.checkNotNull(map);
        UriParameterMap paramMap = new UriParameterMap();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            paramMap.putAll(entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return paramMap;
    }

    @GwtIncompatible
    private static String decodeString(String str, int start, int end, Charset encoding, boolean requiresByteLevelDecoding) {
        try {
            if (requiresByteLevelDecoding) {
                byte[] rawBytes = URLDecoder.decode(str.substring(start, end), "ISO-8859-1").getBytes(ISO_8859_1);
                return new String(rawBytes, encoding);
            }
            return URLDecoder.decode(str.substring(start, end), encoding.name());
        }
        catch (IllegalArgumentException iae) {
            return str.substring(start, end);
        }
        catch (UnsupportedEncodingException e) {
            return str.substring(start, end);
        }
    }

    @GwtIncompatible
    private static boolean requiresByteLevelDecoding(Charset charset) {
        String encoding = charset.name();
        int len = encoding.length();
        return len >= "SHIFT_JIS".length() && encoding.regionMatches(true, len - "SHIFT_JIS".length(), "SHIFT_JIS", 0, "SHIFT_JIS".length()) || len >= "WINDOWS-31J".length() && encoding.regionMatches(true, len - "WINDOWS-31J".length(), "WINDOWS-31J", 0, "WINDOWS-31J".length());
    }

    public static UriParameterMap unmodifiableMap(UriParameterMap map) {
        return new UriParameterMap(Multimaps.unmodifiableListMultimap(map.delegate()));
    }

    @Override
    protected ListMultimap<String, String> delegate() {
        return this.delegate;
    }

    public String getFirst(String key) {
        Preconditions.checkNotNull(key);
        Collection values = this.get(key);
        return values.isEmpty() ? null : (String)values.get(0);
    }

    @GwtIncompatible
    public void appendTo(StringBuilder out, Charset encoding) {
        try {
            this.appendTo((Appendable)out, encoding);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @GwtIncompatible
    public void appendTo(Appendable out, Charset encoding) throws IOException {
        Iterator it = this.entries().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            out.append(UriEncoder.encode((String)entry.getKey(), encoding));
            if (!"".equals(entry.getValue())) {
                out.append('=').append(UriEncoder.encode((String)entry.getValue(), encoding));
            }
            if (!it.hasNext()) continue;
            out.append('&');
        }
    }

    public UriParameterMap clone() {
        return new UriParameterMap(LinkedListMultimap.create(this.delegate()));
    }

    public ImmutableMap<String, String[]> copyToArrayMap() {
        return ImmutableMap.copyOf(Maps.transformValues(this.delegate.asMap(), new Function<Collection<String>, String[]>(this){

            @Override
            public String[] apply(Collection<String> from) {
                return from.toArray(new String[from.size()]);
            }
        }));
    }

    @GwtIncompatible
    public String toString(Charset encoding) {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder, encoding);
        return builder.toString();
    }

    @Override
    public String toString() {
        return Platform.uriParameterMapToString(this);
    }

    void merge(UriParameterMap other) {
        this.delegate.putAll(other.delegate);
    }
}

