/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.Uri;
import com.google.common.net.UriBuilder;
import com.google.common.net.UriResolver;

@GoogleInternal
@GwtIncompatible
public final class UriResolvers {
    private static final UriResolver DEFAULT_RESOLVER = UriResolvers.rfc3986Resolver(false);

    public static UriResolver rfc3986Resolver(boolean isStrict) {
        return new Rfc3986Resolver(isStrict);
    }

    public static Uri resolve(Uri base, Uri reference) {
        return DEFAULT_RESOLVER.resolve(base, reference);
    }

    @VisibleForTesting
    static Uri undefinedPathToEmptyPath(Uri uri) {
        if (uri.getPath() == null) {
            return UriBuilder.of(uri).setPath("").getUri();
        }
        return uri;
    }

    private UriResolvers() {
    }

    static final class Rfc3986Resolver
    implements UriResolver {
        private final boolean isStrict;

        private Rfc3986Resolver(boolean isStrict) {
            this.isStrict = isStrict;
        }

        @Override
        public final Uri resolve(Uri base, Uri reference) {
            base = UriResolvers.undefinedPathToEmptyPath(base);
            reference = UriResolvers.undefinedPathToEmptyPath(reference);
            Preconditions.checkArgument(base.getScheme() != null, "base URI scheme must be defined: %s", (Object)base);
            Rfc3986Resolver.checkAuthorityWithRelativePath(base, "base");
            Rfc3986Resolver.checkAuthorityWithRelativePath(reference, "reference");
            return this.resolveValidInput(base, reference);
        }

        private static void checkAuthorityWithRelativePath(Uri uri, String name) {
            Preconditions.checkArgument(uri.getAuthority() == null || uri.getPath().startsWith("/") || uri.getPath().equals(""), "when authority is present, path must be empty or start with '/': %s URI %s", (Object)name, (Object)uri);
        }

        protected Uri resolveValidInput(Uri base, Uri reference) {
            if (this.isStrict && reference.getScheme() != null) {
                return reference;
            }
            UriBuilder target = new UriBuilder();
            if (!this.isStrict && base.getScheme().equals(reference.getScheme())) {
                reference = UriBuilder.of(reference).setScheme(null).getUri();
            }
            if (reference.getScheme() != null) {
                target.setScheme(reference.getScheme());
                target.setAuthority(reference.getAuthority());
                target.setPath(Rfc3986Resolver.removeDotSegments(reference.getPath()));
                target.setQuery(reference.getQuery());
            } else {
                if (reference.getAuthority() != null) {
                    target.setAuthority(reference.getAuthority());
                    target.setPath(Rfc3986Resolver.removeDotSegments(reference.getPath()));
                    target.setQuery(reference.getQuery());
                } else {
                    if (reference.getPath().equals("")) {
                        target.setPath(base.getPath());
                        if (reference.getQuery() != null) {
                            target.setQuery(reference.getQuery());
                        } else {
                            target.setQuery(base.getQuery());
                        }
                    } else {
                        if (reference.getPath().startsWith("/")) {
                            target.setPath(Rfc3986Resolver.removeDotSegments(reference.getPath()));
                        } else {
                            target.setPath(Rfc3986Resolver.mergePaths(base, reference));
                            target.setPath(Rfc3986Resolver.removeDotSegments(target.getPath()));
                        }
                        target.setQuery(reference.getQuery());
                    }
                    target.setAuthority(base.getAuthority());
                }
                target.setScheme(base.getScheme());
            }
            target.setFragment(reference.getFragment());
            return target.getUri();
        }

        private static String mergePaths(Uri base, Uri reference) {
            if (base.getAuthority() != null && base.getPath().equals("")) {
                String string = String.valueOf(reference.getPath());
                return string.length() != 0 ? "/".concat(string) : new String("/");
            }
            return Rfc3986Resolver.appendReferencePathToBaseDirName(base, reference);
        }

        static String appendReferencePathToBaseDirName(Uri base, Uri reference) {
            int lastSlashIndex = base.getPath().lastIndexOf(47);
            if (lastSlashIndex > -1) {
                String string = String.valueOf(base.getPath().substring(0, lastSlashIndex + 1));
                String string2 = String.valueOf(reference.getPath());
                return string2.length() != 0 ? string.concat(string2) : new String(string);
            }
            return reference.getPath();
        }

        private static String removeDotSegments(String path) {
            StringBuilder input = new StringBuilder(path);
            StringBuilder output = new StringBuilder();
            while (input.length() > 0) {
                int firstSlash;
                if (Rfc3986Resolver.removePrefix(input, "../") || Rfc3986Resolver.removePrefix(input, "./") || Rfc3986Resolver.replacePrefix(input, "/./", "/") || Rfc3986Resolver.replaceContents(input, "/.", "/")) continue;
                if (Rfc3986Resolver.replacePrefix(input, "/../", "/") || Rfc3986Resolver.replaceContents(input, "/..", "/")) {
                    int lastSlash = output.lastIndexOf("/");
                    if (lastSlash == -1) {
                        lastSlash = 0;
                    }
                    output.delete(lastSlash, output.length());
                    continue;
                }
                if (Rfc3986Resolver.replaceContents(input, ".", "") || Rfc3986Resolver.replaceContents(input, "..", "")) continue;
                if (input.charAt(0) == '/') {
                    input.deleteCharAt(0);
                    output.append('/');
                }
                if ((firstSlash = input.indexOf("/")) == -1) {
                    firstSlash = input.length();
                }
                output.append(input.substring(0, firstSlash));
                input.delete(0, firstSlash);
            }
            return output.toString();
        }

        private static boolean removePrefix(StringBuilder input, String prefix) {
            if (input.toString().startsWith(prefix)) {
                input.delete(0, prefix.length());
                return true;
            }
            return false;
        }

        private static boolean replacePrefix(StringBuilder input, String prefix, String replacement) {
            if (input.toString().startsWith(prefix)) {
                input.replace(0, prefix.length(), replacement);
                return true;
            }
            return false;
        }

        private static boolean replaceContents(StringBuilder input, String oldContents, String newContents) {
            if (input.toString().equals(oldContents)) {
                input.replace(0, oldContents.length(), newContents);
                return true;
            }
            return false;
        }

        public String toString() {
            String string = String.valueOf(this.isStrict ? "strict" : "non-strict");
            return string.length() != 0 ? "RFC 3986 resolver, ".concat(string) : new String("RFC 3986 resolver, ");
        }
    }
}

