/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.net.UnrecognizedUserAgentException;
import com.google.common.net.UriEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@GoogleInternal
@GwtIncompatible
public final class UserAgent {
    private static final String kRegexpLocale = "([a-zA-Z]{2}(?:-[a-zA-Z]{2,3})?(?:-mac)?)";
    private static final ImmutableList<Parser> PARSERS = ImmutableList.of(new MsieParser(), new MsieGoogleToolbarParser(), new GeckoParser(), new SafariParser(), new OperaParser(), new KonquerorParser());
    private final Family family;
    private final String product;
    private final String version;
    private final String platform;
    private final String operatingSystem;
    private final Engine engine;
    private final String engineVersion;
    private final String locale;
    private final String toolbarVersion;
    private static final String GZIPGFE = "gzip(gfe)";
    private static final int GZIPGFELEN = "gzip(gfe)".length();

    @Deprecated
    public UserAgent(@Nullable Family family, @Nullable String product, @Nullable String version, @Nullable String platform, @Nullable String operatingSystem, @Nullable Engine engine, @Nullable String engineVersion, @Nullable String locale, @Nullable String toolbarVersion) {
        this.family = family;
        this.product = product;
        this.version = version;
        this.platform = platform;
        this.operatingSystem = operatingSystem;
        this.engine = engine;
        this.engineVersion = engineVersion;
        this.locale = locale;
        this.toolbarVersion = toolbarVersion;
    }

    public Family getFamily() {
        return this.family;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getLocaleString() {
        return this.locale;
    }

    public String getToolbarVersion() {
        return this.toolbarVersion;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UserAgent) {
            UserAgent that = (UserAgent)object;
            return Objects.equal((Object)this.family, (Object)that.family) && Objects.equal(this.product, that.product) && Objects.equal(this.version, that.version) && Objects.equal(this.platform, that.platform) && Objects.equal(this.operatingSystem, that.operatingSystem) && Objects.equal((Object)this.engine, (Object)that.engine) && Objects.equal(this.engineVersion, that.engineVersion) && Objects.equal(this.locale, that.locale) && Objects.equal(this.toolbarVersion, that.toolbarVersion);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.family, this.product, this.version, this.platform, this.operatingSystem, this.engine, this.engineVersion, this.locale, this.toolbarVersion});
    }

    public String toString() {
        return Joiner.on("|").useForNull("").join("", (Object)this.family, new Object[]{this.product, this.version, this.platform, this.operatingSystem, this.engine, this.engineVersion, this.locale, this.toolbarVersion, ""});
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean hasHexDigitsAfterPercent(String ua) {
        int index = 0;
        while ((index = ua.indexOf(37, index)) >= 0 && index < ua.length() - 2) {
            if (UserAgent.isHexDigit(ua.charAt(index + 1)) && UserAgent.isHexDigit(ua.charAt(index + 2))) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private static String removeDoubleQuotes(String ua) {
        int len = ua.length();
        if (len > 1 && ua.charAt(0) == '\"' && ua.charAt(len - 1) == '\"') {
            return CharMatcher.whitespace().trimFrom(ua.substring(1, len - 1));
        }
        return ua;
    }

    private static String removeGzipGfes(String ua) {
        while (ua.endsWith(GZIPGFE)) {
            ua = CharMatcher.whitespace().trimFrom(ua.substring(0, ua.length() - GZIPGFELEN));
            if (!ua.endsWith(",")) continue;
            ua = CharMatcher.whitespace().trimFrom(ua.substring(0, ua.length() - 1));
        }
        return ua;
    }

    private static String unescapeUrl(String ua) {
        String unescapedUa;
        if (UserAgent.hasHexDigitsAfterPercent(ua) && (unescapedUa = CharMatcher.whitespace().trimFrom(UriEncoder.lenientDecode(ua, StandardCharsets.UTF_8, true))).length() > 0) {
            ua = unescapedUa;
        }
        return ua;
    }

    @Deprecated
    public static String normalize(String ua) {
        return UserAgent.unescapeUrl(UserAgent.removeGzipGfes(UserAgent.removeDoubleQuotes(CharMatcher.whitespace().trimFrom(ua))));
    }

    @Deprecated
    public static UserAgent parse(String ua) throws UnrecognizedUserAgentException {
        String uan = UserAgent.normalize(ua);
        for (Parser parser : PARSERS) {
            UserAgent result = parser.tryToParse(uan);
            if (result == null) continue;
            return result;
        }
        throw new UnrecognizedUserAgentException(ua);
    }

    public String canonicalize() {
        for (Parser parser : PARSERS) {
            String result = parser.toCanonicalString(this);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static class KonquerorParser
    implements Parser {
        private static final Pattern PATTERN = Pattern.compile("^Mozilla/5\\.0 \\(compatible; Konqueror/([^;\\)]+)(?:; ([^;\\)]+)(?:;[^;\\)]*)*)?\\)(?: KHTML/(\\S+))?");

        private KonquerorParser() {
        }

        @Override
        public UserAgent tryToParse(String ua) {
            Matcher matcher = PATTERN.matcher(ua);
            if (matcher.find() && matcher.groupCount() == 3) {
                return new UserAgent(Family.KONQUEROR, Family.KONQUEROR.toString(), matcher.group(1), matcher.group(2), matcher.group(2), Engine.KHTML, matcher.group(3), null, null);
            }
            return null;
        }

        @Override
        public String toCanonicalString(UserAgent ua) {
            String string;
            if (ua.getFamily() != Family.KONQUEROR) {
                return null;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = ua.getProduct();
            objectArray[1] = ua.getVersion();
            if (ua.getPlatform() != null) {
                String string2 = String.valueOf(ua.getPlatform());
                string = string2.length() != 0 ? "; ".concat(string2) : new String("; ");
            } else {
                string = "";
            }
            objectArray[2] = string;
            objectArray[3] = ua.getEngineVersion() != null ? String.format(" %s/%s", new Object[]{ua.getEngine(), ua.getEngineVersion()}) : "";
            return String.format("Mozilla/5.0 (compatible; %s/%s%s)%s", objectArray);
        }
    }

    private static class OperaParser
    implements Parser {
        private static final Pattern PATTERN = Pattern.compile("^Opera/(\\S+) \\((?:([^;]+); )?([^;]+); ([UIN]); (?:[^;]*; )*([a-zA-Z]{2}(?:-[a-zA-Z]{2,3})?(?:-mac)?)\\)");

        private OperaParser() {
        }

        @Override
        public UserAgent tryToParse(String ua) {
            Matcher matcher = PATTERN.matcher(ua);
            if (matcher.find() && matcher.groupCount() == 5) {
                String platform = matcher.group(2);
                if (platform == null && matcher.group(3).toLowerCase().contains("windows")) {
                    platform = "Windows";
                }
                return new UserAgent(Family.OPERA, Engine.OPERA.toString(), matcher.group(1), platform, matcher.group(3), Engine.OPERA, matcher.group(1), matcher.group(5), null);
            }
            return null;
        }

        @Override
        public String toCanonicalString(UserAgent ua) {
            if (ua.getFamily() != Family.OPERA) {
                return null;
            }
            return String.format("Opera/%s (%s; U; %s)", ua.getVersion(), ua.getOperatingSystem(), ua.getLocaleString());
        }
    }

    private static class SafariParser
    implements Parser {
        private static final Pattern PATTERN = Pattern.compile("^Mozilla/5\\.0 \\(([^;]+); ([UIN]); ([^;]+); ([a-zA-Z]{2}(?:-[a-zA-Z]{2,3})?(?:-mac)?)(?:;[^;]*)?\\) AppleWebKit/(\\S+) \\(KHTML, like Gecko.*\\) ([^/]+)/(v?\\d+[\\.\\w]*)");

        private SafariParser() {
        }

        @Override
        public UserAgent tryToParse(String ua) {
            Matcher matcher = PATTERN.matcher(ua);
            if (matcher.find() && matcher.groupCount() == 7) {
                String product = CharMatcher.whitespace().trimFrom(matcher.group(6));
                if (product.equals("Version")) {
                    product = Family.SAFARI.toString();
                }
                return new UserAgent(Family.SAFARI, product, matcher.group(7), matcher.group(1), matcher.group(3), Engine.WEBKIT, matcher.group(5), matcher.group(4), null);
            }
            return null;
        }

        @Override
        public String toCanonicalString(UserAgent ua) {
            if (ua.getFamily() != Family.SAFARI) {
                return null;
            }
            return String.format("Mozilla/5.0 (%s; U; %s; %s) %s/%s (KHTML, like Gecko) %s/%s", new Object[]{ua.getPlatform(), ua.getOperatingSystem(), ua.getLocaleString(), ua.getEngine(), ua.getEngineVersion(), ua.getProduct(), ua.getVersion()});
        }
    }

    private static class GeckoParser
    implements Parser {
        private static final Pattern PATTERN = Pattern.compile("^Mozilla/5\\.0 \\(([^;]+); ([UIN]); ([^;]+); (?:([a-zA-Z]{2}(?:-[a-zA-Z]{2,3})?(?:-mac)?); )?(?:.*rv:([^;]+)(?:;[^;]*)*)\\) Gecko/\\d{8,10}(?: \\(.+\\))?(?:(?: [^ ]+)* ([^/]+)/(v?\\d+[\\.\\w]*))?(?: GoogleToolbarFF (\\d+[\\.\\w]*))?");

        private GeckoParser() {
        }

        @Override
        public UserAgent tryToParse(String ua) {
            Matcher matcher = PATTERN.matcher(ua);
            if (matcher.find() && matcher.groupCount() == 8) {
                String product = matcher.group(6);
                if (product != null && (product = CharMatcher.whitespace().trimFrom(product)).endsWith(" Firefox")) {
                    product = "Firefox";
                }
                return new UserAgent(Family.GECKO, product, matcher.group(7), matcher.group(1), matcher.group(3), Engine.GECKO, matcher.group(5), matcher.group(4), matcher.group(8));
            }
            return null;
        }

        @Override
        public String toCanonicalString(UserAgent ua) {
            if (ua.getFamily() != Family.GECKO) {
                return null;
            }
            return String.format("Mozilla/5.0 (%s; U; %s;%s rv:%s) %s/19700101%s%s", new Object[]{ua.getPlatform(), ua.getOperatingSystem(), ua.getLocaleString() != null ? String.format(" %s;", ua.getLocaleString()) : "", ua.getEngineVersion(), ua.getEngine(), ua.getProduct() != null ? String.format(" %s/%s", ua.getProduct(), ua.getVersion()) : "", ua.getToolbarVersion() != null ? String.format(" GoogleToolbarFF %s", ua.getToolbarVersion()) : ""});
        }
    }

    private static class MsieGoogleToolbarParser
    implements Parser {
        private static final Pattern PATTERN = Pattern.compile("^Mozilla/4\\.0 \\(compatible; GoogleToolbar ([^;]+); ([^;]+)(?:; MSIE ([^;]+))?(?:;[^;]*)*\\)");

        private MsieGoogleToolbarParser() {
        }

        @Override
        public UserAgent tryToParse(String ua) {
            Matcher matcher = PATTERN.matcher(ua);
            if (!matcher.find() || matcher.groupCount() != 3) {
                return null;
            }
            String toolbarVersion = matcher.group(1);
            String operatingSystem = matcher.group(2);
            String version = matcher.group(3);
            String platform = null;
            if (operatingSystem.toLowerCase().contains("windows")) {
                platform = "Windows";
            }
            return new UserAgent(Family.MSIE, "MSIE", version, platform, operatingSystem, Engine.MSIE, version, null, toolbarVersion);
        }

        @Override
        public String toCanonicalString(UserAgent ua) {
            if (ua.getFamily() != Family.MSIE || ua.getToolbarVersion() == null) {
                return null;
            }
            return String.format("Mozilla/4.0 (compatible; GoogleToolbar %s; %s%s)", ua.getToolbarVersion(), ua.getOperatingSystem(), ua.getEngineVersion() != null ? String.format("; %s %s", new Object[]{ua.getEngine(), ua.getEngineVersion()}) : "");
        }
    }

    private static class MsieParser
    implements Parser {
        private static final Pattern PATTERN = Pattern.compile("^Mozilla/4\\.0 \\(compatible; MSIE ([^;]+); ([^;]+)(?:; ([^;]+))?(?:;[^;]*)*(\\))(?: ([^/\\s]+)[/\\s](v?\\d+[\\.\\w]*))?");

        private MsieParser() {
        }

        @Override
        public UserAgent tryToParse(String ua) {
            Matcher matcher = PATTERN.matcher(ua);
            if (!matcher.find() || matcher.groupCount() != 6) {
                return null;
            }
            String operatingSystem = null;
            for (int i = 2; i < 4; ++i) {
                if (matcher.group(i) == null || !matcher.group(i).toLowerCase().contains("windows")) continue;
                operatingSystem = matcher.group(i);
                break;
            }
            if (operatingSystem == null) {
                operatingSystem = matcher.group(2);
            }
            String platform = null;
            if (operatingSystem.toLowerCase().contains("windows")) {
                platform = "Windows";
            }
            String product = matcher.group(5);
            String version = matcher.group(6);
            if (product == null) {
                product = Engine.MSIE.toString();
                version = matcher.group(1);
            }
            return new UserAgent(Family.MSIE, product, version, platform, operatingSystem, Engine.MSIE, matcher.group(1), null, null);
        }

        @Override
        public String toCanonicalString(UserAgent ua) {
            if (ua.getFamily() != Family.MSIE || ua.getToolbarVersion() != null) {
                return null;
            }
            return String.format("Mozilla/4.0 (compatible; %s %s; %s) %s %s", new Object[]{ua.getEngine(), ua.getEngineVersion(), ua.getOperatingSystem(), ua.getProduct(), ua.getVersion()});
        }
    }

    private static interface Parser {
        public UserAgent tryToParse(String var1);

        public String toCanonicalString(UserAgent var1);
    }

    public static enum Engine {
        MSIE("MSIE"),
        GECKO("Gecko"),
        WEBKIT("AppleWebKit"),
        KHTML("KHTML"),
        OPERA("Opera");

        private final String name;

        private Engine(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Family {
        MSIE("MSIE"),
        GECKO("Gecko"),
        SAFARI("Safari"),
        OPERA("Opera"),
        KONQUEROR("Konqueror");

        private final String name;

        private Family(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

