/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.apphosting.contrib.AppEngineEnvironment;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Pair;
import com.google.common.base.Preconditions;
import com.google.common.net.useragent.UserAgentPb;
import com.google.wireless.mdl.UserAgentMatcher;
import com.google.wireless.mdl.UserAgentUnified;
import com.google.wireless.mdl.internal.parser.yacc.javawrap_user_agent_classifier.main;
import com.google.wrappers.base.GoogleInit;

@GoogleInternal
@GwtIncompatible
public final class UserAgentClassifier {
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static UserAgentPb.UserAgentProto classifyUserAgent(String userAgent) {
        Preconditions.checkState(SUPPORTED);
        Preconditions.checkNotNull(userAgent);
        UserAgentMatcher.ParsedUserAgent.Builder builder = UserAgentMatcher.ParsedUserAgent.newBuilder();
        main.classify_user_agent((String)userAgent, (UserAgentMatcher.ParsedUserAgent.Builder)builder);
        return builder.build().getUserAgent();
    }

    public static Pair<UserAgentPb.UserAgentProto, UserAgentUnified.UnifiedUserAgent.DeviceRequestType> classifyUserAgentAndRequestType(String userAgent) {
        Preconditions.checkState(SUPPORTED);
        Preconditions.checkNotNull(userAgent);
        UserAgentMatcher.ParsedUserAgent.Builder builder = UserAgentMatcher.ParsedUserAgent.newBuilder();
        UserAgentUnified.UnifiedUserAgent.DeviceRequestType requestType = UserAgentUnified.UnifiedUserAgent.DeviceRequestType.forNumber((int)main.classify_user_agent_and_request_type((String)userAgent, (UserAgentMatcher.ParsedUserAgent.Builder)builder));
        return Pair.of(builder.build().getUserAgent(), requestType);
    }

    static {
        boolean bl = SUPPORTED = !AppEngineEnvironment.detect().isAppEngine();
        if (SUPPORTED && !GoogleInit.isInitialized()) {
            GoogleInit.initializeLibraryWithSystemPropertyFlags((String)UserAgentClassifier.class.getName());
        }
    }
}

