/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firebear.client;

import com.google.common.base.Preconditions;
import com.google.common.time.Clock;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class ClockWithSkew {
    public static final Duration MAX_ALLOW_SKEW = Duration.standardMinutes(5L);
    private final Clock clock;
    private final Duration skew;

    public ClockWithSkew(Clock clock, Duration skew) {
        Preconditions.checkArgument(skew.getMillis() >= 0L, "Cannot have a negative skew.");
        Preconditions.checkArgument(MAX_ALLOW_SKEW.isLongerThan(skew), "Any skew greater than 5 minutes is not reasonable.");
        this.clock = clock;
        this.skew = skew;
    }

    public boolean isNowBetween(Instant start, Instant end) {
        Instant now = this.clock.now();
        Instant startMinusSkew = start.minus(this.skew);
        Instant endPlusSkew = end.plus(this.skew);
        return startMinusSkew.isBefore(now) && endPlusSkew.isAfter(now);
    }
}

