/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firebear.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.common.labs.concurrent.RetryStrategy;
import com.google.common.labs.concurrent.RetryingFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.firebear.client.FirebearCertificateProviderInterface;
import com.google.firebase.firebear.client.PublicCertificateFetcher;
import com.google.gaia.mint.proto2api.PublicCertificate;
import com.google.iam.credentials.v1.CloudGaia;
import com.google.iam.credentials.v1.ListPublicCertificatesRequest;
import com.google.net.rpc3.client.RpcClientContext;
import com.google.net.rpc3.client.RpcFuture;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Duration;

@ThreadSafe
public class FirebearCertificateProvider
implements FirebearCertificateProviderInterface,
Runnable {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/firebear/client/FirebearCertificateProvider");
    private final PublicCertificateFetcher fetcher;
    private final long robotId;
    private final Duration refreshInterval;
    @GuardedBy(value="mutex")
    private ImmutableMap<String, X509Certificate> certificates;
    @GuardedBy(value="mutex")
    private boolean running;
    @GuardedBy(value="mutex")
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> scheduledFuture;
    private ReadWriteLock mutex;
    private final RetryStrategy retryStrategy;

    public FirebearCertificateProvider(CloudGaia.FutureInterface cloudGaia, long robotId, RetryStrategy retryStrategy, Duration refreshInterval, ScheduledExecutorService scheduledExecutorService) {
        this(new CloudGaiaPublicCertificateFetcher(cloudGaia), robotId, retryStrategy, refreshInterval, scheduledExecutorService);
    }

    public FirebearCertificateProvider(PublicCertificateFetcher fetcher, long robotId, RetryStrategy retryStrategy, Duration refreshInterval, ScheduledExecutorService scheduledExecutorService) {
        this.fetcher = fetcher;
        this.robotId = robotId;
        this.refreshInterval = refreshInterval;
        this.mutex = new ReentrantReadWriteLock();
        this.scheduledExecutorService = scheduledExecutorService;
        this.retryStrategy = retryStrategy;
    }

    @Override
    @Nullable
    public X509Certificate getCertificate(String kid) {
        this.mutex.readLock().lock();
        try {
            Preconditions.checkState(this.running, "Not started.");
            X509Certificate x509Certificate = this.certificates.get(kid);
            return x509Certificate;
        }
        finally {
            this.mutex.readLock().unlock();
        }
    }

    public void start() {
        try {
            this.startAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public ListenableFuture<Void> startAsync() {
        this.mutex.writeLock().lock();
        try {
            if (this.running) {
                ListenableFuture<Object> listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture<Void> listenableFuture = Futures.transform(this.refresh(), unusedVoid -> {
                this.mutex.writeLock().lock();
                try {
                    if (!this.running) {
                        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this, this.refreshInterval.getMillis(), this.refreshInterval.getMillis(), TimeUnit.MILLISECONDS);
                        this.running = true;
                    }
                }
                finally {
                    this.mutex.writeLock().unlock();
                }
                return null;
            }, MoreExecutors.directExecutor());
            return listenableFuture;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
    }

    @Override
    public void run() {
        try {
            Futures.addCallback(this.refresh(), new FutureCallback<Void>(this){

                @Override
                public void onSuccess(Void v) {
                }

                @Override
                public void onFailure(Throwable t) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(t)).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider$1", "onFailure", 157, "FirebearCertificateProvider.java")).log("Ignoring error so that scheduler will schedule the next run.");
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider", "run", 164, "FirebearCertificateProvider.java")).log("Ignoring error so that scheduler will schedule the next run.");
        }
    }

    public void stop() {
        this.mutex.writeLock().lock();
        try {
            Preconditions.checkState(this.running, "Not started.");
            this.scheduledFuture.cancel(true);
            this.running = false;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
    }

    private ListenableFuture<Void> refresh() {
        RetryingFuture newCertsFuture;
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider", "refresh", 182, "FirebearCertificateProvider.java")).log("Refreshing the keys.");
        try {
            newCertsFuture = RetryingFuture.retryingFuture(() -> this.fetcher.listCertificatesForRobot(this.robotId), (RetryStrategy)this.retryStrategy, Predicates.alwaysTrue(), (Executor)MoreExecutors.directExecutor());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to update the keys and all the retries are exhausted.", e);
        }
        return Futures.transform(newCertsFuture, newCerts -> {
            this.mutex.writeLock().lock();
            try {
                this.certificates = newCerts;
            }
            finally {
                this.mutex.writeLock().unlock();
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/firebear/client/FirebearCertificateProvider", "lambda$refresh$2", 204, "FirebearCertificateProvider.java")).log("Keys has been refreshed successfully.");
            return null;
        }, MoreExecutors.directExecutor());
    }

    public static class CloudGaiaPublicCertificateFetcher
    implements PublicCertificateFetcher {
        private final CloudGaia.FutureInterface cloudGaia;

        public CloudGaiaPublicCertificateFetcher(CloudGaia.FutureInterface cloudGaia) {
            this.cloudGaia = cloudGaia;
        }

        @Override
        public ListenableFuture<ImmutableMap<String, X509Certificate>> listCertificatesForRobot(long robotId) {
            ListPublicCertificatesRequest req = ListPublicCertificatesRequest.newBuilder().setName(String.valueOf(robotId)).build();
            RpcFuture responseFuture = this.cloudGaia.listPublicCertificates(RpcClientContext.create(), req);
            return Futures.transform(responseFuture, response -> response.getPublicCertificateList().stream().filter(cert -> !cert.getX509CertificatePem().isEmpty()).collect(ImmutableMap.toImmutableMap(PublicCertificate::getKeyName, CloudGaiaPublicCertificateFetcher::toX509Certificate)), MoreExecutors.directExecutor());
        }

        private static X509Certificate toX509Certificate(PublicCertificate cert) {
            try {
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(cert.getX509CertificatePem().getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load certificates. Error message: %s", e.getCause()));
            }
        }
    }
}

