/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firebear.client;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.firebase.firebear.client.ClockWithSkew;
import com.google.firebase.firebear.client.FirebearCertificateProviderInterface;
import com.google.firebase.firebear.client.JwtToken;
import com.google.firebase.firebear.client.JwtVerificationException;
import com.google.firebase.firebear.client.JwtVerifier;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.joda.time.Instant;

public class FirebearJwtVerifier
implements JwtVerifier {
    public static final long FIREBEAR_ROBOT_GAIA_ID = 556943840060L;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/firebear/client/FirebearJwtVerifier");
    private static final String STS_ISSUER_ENDPOINT = "https://securetoken.google.com";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private final ClockWithSkew clockWithSkew;
    private final FirebearCertificateProviderInterface firebearCertificateProvider;
    private final ImmutableList<String> headerPrefixes;

    public FirebearJwtVerifier(ClockWithSkew clockWithSkew, FirebearCertificateProviderInterface firebearCertificateProvider) {
        this(clockWithSkew, firebearCertificateProvider, ImmutableList.of("Firebear ", "Firebase ", "Bearer "));
    }

    public FirebearJwtVerifier(ClockWithSkew clockWithSkew, FirebearCertificateProviderInterface firebearCertificateProvider, ImmutableList<String> headerPrefixes) {
        this.clockWithSkew = clockWithSkew;
        this.firebearCertificateProvider = firebearCertificateProvider;
        this.headerPrefixes = headerPrefixes;
    }

    @Override
    public JwtToken verifyJwt(String expectedAudience, CharSequence jwt) throws JwtVerificationException {
        JwtToken token = JwtToken.deserialize(jwt);
        String kid = token.getKeyId();
        if (Strings.isNullOrEmpty(kid)) {
            throw new JwtVerificationException("Invalid 'kid' claim. 'kid' is not set.", JwtVerificationException.Reason.INVALID);
        }
        X509Certificate cert = this.firebearCertificateProvider.getCertificate(kid);
        if (cert == null) {
            throw new JwtVerificationException("Invalid 'kid' claim. public key for 'kid' is not found.", JwtVerificationException.Reason.INVALID);
        }
        this.verifySignature(token, cert);
        Instant issuedAt = token.getIssuedAt();
        Instant expiresAt = token.getExpiresAt();
        if (issuedAt == null) {
            throw this.logAsSevereAndThrow("Invalid 'iat' claim. 'iat' is not set.", JwtVerificationException.Reason.INVALID);
        }
        if (expiresAt == null) {
            throw this.logAsSevereAndThrow("Invalid 'exp' claim. 'exp' is not set.", JwtVerificationException.Reason.INVALID);
        }
        if (issuedAt.isAfter(expiresAt)) {
            throw this.logAsSevereAndThrow("Invalid 'exp' claim. 'iat' is bigger than 'exp'.", JwtVerificationException.Reason.INVALID);
        }
        String audience = token.getAudience();
        String issuer = token.getIssuer();
        if (Strings.isNullOrEmpty(audience)) {
            throw this.logAsSevereAndThrow("Invalid 'aud' claim. 'aud' is not set.", JwtVerificationException.Reason.INVALID);
        }
        if (Strings.isNullOrEmpty(issuer)) {
            throw this.logAsSevereAndThrow("Invalid 'iss' claim. 'iss' is not set.", JwtVerificationException.Reason.INVALID);
        }
        String string = String.valueOf("https://securetoken.google.com/");
        String string2 = String.valueOf(audience);
        if (!issuer.equals(string2.length() != 0 ? string.concat(string2) : new String(string))) {
            throw this.logAsSevereAndThrow(String.format("Invalid 'iss' claim. The 'aud' is %s but the 'iss' is set to %s.", audience, issuer), JwtVerificationException.Reason.INVALID);
        }
        String subject = token.getSubject();
        if (Strings.isNullOrEmpty(subject)) {
            throw this.logAsSevereAndThrow("Invalid 'sub' claim. 'sub' is not set.", JwtVerificationException.Reason.INVALID);
        }
        if (!this.clockWithSkew.isNowBetween(issuedAt, expiresAt)) {
            throw new JwtVerificationException("Invalid 'exp' Claim. 'exp' is expired.", JwtVerificationException.Reason.INVALID_TIME_CLAIM);
        }
        if (!audience.equals(expectedAudience)) {
            throw new JwtVerificationException("Invalid 'aud' claim. 'aud' is not for the current project.", JwtVerificationException.Reason.INVALID);
        }
        return token;
    }

    private void verifySignature(JwtToken token, X509Certificate cert) throws JwtVerificationException {
        Signature verifier;
        try {
            verifier = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            verifier.initVerify(cert.getPublicKey());
            verifier.update(token.getBaseString().getBytes(StandardCharsets.UTF_8));
            if (!verifier.verify(token.getSignature())) {
                throw new JwtVerificationException("Invalid signature", JwtVerificationException.Reason.BAD_SIGNATURE);
            }
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new JwtVerificationException("Invalid signature", JwtVerificationException.Reason.BAD_SIGNATURE);
        }
    }

    @Override
    public JwtToken verifyAuthorizationHeader(String expectedAudience, String authorizationHeader) throws JwtVerificationException {
        for (String prefix : this.headerPrefixes) {
            if (!authorizationHeader.startsWith(prefix)) continue;
            CharSequence jwt = authorizationHeader.subSequence(prefix.length(), authorizationHeader.length());
            return this.verifyJwt(expectedAudience, jwt);
        }
        throw new JwtVerificationException(String.format("Authorization Header should start with %s", Joiner.on("OR").join(this.headerPrefixes)), JwtVerificationException.Reason.INVALID);
    }

    private JwtVerificationException logAsSevereAndThrow(String message, JwtVerificationException.Reason reason) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/firebase/firebear/client/FirebearJwtVerifier", "logAsSevereAndThrow", 158, "FirebearJwtVerifier.java")).log(message);
        return new JwtVerificationException(message, reason);
    }
}

