/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.eventflow.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.firebase.rules.eventflow.client.path.PathMatcher;
import com.google.firebase.rules.eventflow.client.path.PathParser;
import com.google.firebase.rules.eventflow.client.path.PathPattern;
import com.google.firebase.rules.runtime.evaluators.EventRuleEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class EventRuleEvaluatorImpl
implements EventRuleEvaluator {
    public static final EventRuleEvaluator EMPTY_FLOW_EVALUATOR = new EventRuleEvaluatorImpl("projects/no_project/rulesets/no_ruleset", ImmutableList.of(), PathParser.URL_SEGMENT_DECODER);
    private final List<EventRuleEvaluator.Flow> eventRuleFlows;
    private final ImmutableMultimap<String, PathMatcher> flowPatterns;
    private final String rulesetName;

    public EventRuleEvaluatorImpl(String rulesetName, List<EventRuleEvaluator.Flow> flows, Function<String, String> segmentDecoder) {
        this.rulesetName = rulesetName;
        this.eventRuleFlows = ImmutableList.copyOf(flows);
        ImmutableMultimap.Builder patternBuilder = ImmutableMultimap.builder();
        this.eventRuleFlows.forEach(flow -> patternBuilder.put(flow.getName(), PathPattern.compile(flow.getResource(), segmentDecoder)));
        this.flowPatterns = patternBuilder.build();
    }

    @Override
    public List<EventRuleEvaluator.EventRuleMatch> evaluate(EventRuleEvaluator.EventRuleContext ruleContext) {
        return this.eventRuleFlows.stream().flatMap(flow -> this.matches(ruleContext, (EventRuleEvaluator.Flow)flow).stream()).filter(match -> match != null).collect(Collectors.toList());
    }

    @Override
    public Multimap<EventRuleEvaluator.EventRuleContext, EventRuleEvaluator.EventRuleMatch> evaluate(List<EventRuleEvaluator.EventRuleContext> ruleContexts) {
        HashMultimap<EventRuleEvaluator.EventRuleContext, EventRuleEvaluator.EventRuleMatch> resultMap = HashMultimap.create();
        ruleContexts.forEach(ruleContext -> resultMap.putAll((EventRuleEvaluator.EventRuleContext)ruleContext, (Iterable<EventRuleEvaluator.EventRuleMatch>)this.evaluate((EventRuleEvaluator.EventRuleContext)ruleContext)));
        return resultMap;
    }

    @Override
    public String getRulesetName() {
        return this.rulesetName;
    }

    @Override
    public boolean hasNoFlows() {
        return this.eventRuleFlows.isEmpty();
    }

    private Collection<EventRuleEvaluator.EventRuleMatch> matches(EventRuleEvaluator.EventRuleContext ruleContext, EventRuleEvaluator.Flow flow) {
        ArrayList<EventRuleEvaluator.EventRuleMatch> matches = new ArrayList<EventRuleEvaluator.EventRuleMatch>();
        if (ruleContext.eventTypes().contains(flow.getEventType())) {
            Collection pathMatchers = this.flowPatterns.get((Object)flow.getName());
            for (PathMatcher pathMatcher : pathMatchers) {
                PathMatcher.PathMatch pathMatch = pathMatcher.matches(ruleContext.resource());
                if (pathMatch == null) continue;
                matches.add(EventRuleEvaluator.EventRuleMatch.create(flow, pathMatch));
            }
        }
        return matches;
    }
}

