/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.eventflow.client.path;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.eventflow.client.path.AutoValue_Path;
import com.google.firebase.rules.eventflow.client.path.PathParser;
import java.util.function.Function;
import java.util.stream.Collectors;

@AutoValue
public abstract class Path {
    public abstract ImmutableList<CharSequence> segments();

    public String toPath(Function<String, String> segmentEncoder) {
        return this.segments().stream().map(segment -> segment.toString()).map(segmentEncoder).collect(Collectors.joining("/"));
    }

    public static Builder builder() {
        return new AutoValue_Path.Builder();
    }

    public static Path segment(CharSequence segment) {
        Builder builder = Path.builder();
        builder.segmentsBuilder().add((Object)segment);
        return builder.build();
    }

    public static Path segments(Iterable<? extends CharSequence> segments) {
        Builder builder = Path.builder();
        builder.segmentsBuilder().addAll(segments);
        return builder.build();
    }

    public static Path parse(CharSequence urlPath, Function<String, String> segmentDecoder) {
        PathParser.ParseResult parseResult = PathParser.parse(urlPath, segmentDecoder);
        Preconditions.checkArgument(!parseResult.isMatcher(), "Match expressions are not permitted within path values.");
        String string = String.valueOf(parseResult.errorMessage());
        Preconditions.checkArgument(parseResult.errors().isEmpty(), string.length() != 0 ? "Errors parsing path:\n".concat(string) : new String("Errors parsing path:\n"));
        Builder path = Path.builder();
        parseResult.pathNodes().stream().forEach(node -> path.segmentsBuilder().add((Object)node.text()));
        return path.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract ImmutableList.Builder<CharSequence> segmentsBuilder();

        public abstract Path build();
    }
}

