/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.eventflow.client.path;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.net.UrlEscapers;
import com.google.firebase.rules.eventflow.client.path.AutoValue_PathParser_CaptureNode;
import com.google.firebase.rules.eventflow.client.path.AutoValue_PathParser_ParseError;
import com.google.firebase.rules.eventflow.client.path.AutoValue_PathParser_ParseResult;
import com.google.firebase.rules.eventflow.client.path.AutoValue_PathParser_SegmentNode;
import com.google.firebase.rules.eventflow.client.path.ErrorChannel;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PathParser {
    public static final Function<String, String> URL_SEGMENT_DECODER = input -> {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public static final Function<String, String> URL_SEGMENT_ENCODER = UrlEscapers.urlPathSegmentEscaper()::escape;

    private PathParser() {
    }

    public static ParseResult parse(CharSequence path, Function<String, String> segmentDecoder) {
        ArrayList parseErrors = new ArrayList();
        ErrorChannel errorChannel = (errorMessage, parseText, offset) -> parseErrors.add(ParseError.create(errorMessage, parseText, offset));
        ImmutableList<PathNode> pathNodes = new Parser(path, errorChannel, segmentDecoder).parse();
        ImmutableList<ParseError> immutableErrors = ImmutableList.copyOf(parseErrors);
        return ParseResult.create(pathNodes, immutableErrors);
    }

    static class Parser {
        private static final char EQUALS = '=';
        private static final char STAR = '*';
        private static final char SLASH = '/';
        private static final char LBRACKET = '{';
        private static final char RBRACKET = '}';
        private static final char[] SORTED_PCHARS = Parser.sortedPchars();
        private static final CharMatcher PCHAR = c -> Arrays.binarySearch(SORTED_PCHARS, c) >= 0;
        private static final CharMatcher ID_CHAR = c -> c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
        private final ErrorChannel errors;
        private final CharSequence input;
        private final Function<String, String> segmentDecoder;
        private final int inputLength;
        private int position = 0;

        private static char[] sortedPchars() {
            char[] pchars = "~@#$%&.,?:;+*='[]()-".toCharArray();
            Arrays.sort(pchars);
            return pchars;
        }

        Parser(CharSequence input, ErrorChannel errors, Function<String, String> segmentDecoder) {
            this.input = input;
            this.inputLength = input.length();
            this.errors = errors;
            this.segmentDecoder = segmentDecoder;
        }

        ImmutableList<PathNode> parse() {
            ImmutableList.Builder pathNodes = ImmutableList.builder();
            long multiSegmentMatcherCount = 0L;
            while (!this.eof() && (this.consumeChar('/') || this.position == 0)) {
                if (this.eof()) {
                    this.errors.reportError("Unexpected end of input at start of path segment.", "<eof>", this.inputLength);
                    break;
                }
                if (this.matchesChar('/')) {
                    this.errors.reportError("Empty path segments are not permitted.", String.valueOf('/'), this.position);
                    continue;
                }
                if (this.consumeChar('{')) {
                    int startPos = this.position;
                    CaptureNode captureNode = this.capture();
                    pathNodes.add(captureNode);
                    if (!captureNode.multiSegment() || ++multiSegmentMatcherCount <= 1L) continue;
                    this.errors.reportError("Too many multi-segment captures expressions in path.", captureNode.text(), startPos);
                    continue;
                }
                if (!this.matchesChar(ID_CHAR) && !this.matchesChar(PCHAR)) break;
                pathNodes.add(this.segment());
            }
            if (!this.eof()) {
                this.errors.reportError("Unrecognized character(s) at end of path.", this.input.subSequence(this.position, this.inputLength), this.position);
            }
            return pathNodes.build();
        }

        private SegmentNode segment() {
            String predecode;
            int start = this.position;
            while (this.consumeChar(ID_CHAR) || this.consumeChar(PCHAR)) {
            }
            String decoded = predecode = this.input.subSequence(start, this.position).toString();
            try {
                decoded = this.segmentDecoder.apply(predecode);
            }
            catch (IllegalArgumentException e) {
                this.errors.reportError("Could not URL decode path segment.", predecode, start);
            }
            return SegmentNode.create(decoded, start);
        }

        private CaptureNode capture() {
            int start = this.position;
            StringBuilder variableId = new StringBuilder();
            while (this.consumeChar(ID_CHAR)) {
            }
            if (start != this.position) {
                variableId.append(this.input.subSequence(start, this.position));
            } else {
                this.errors.reportError("Expected variable identifier at start of capture expression.", this.currCharOrEof(), this.position);
            }
            boolean multiSegment = false;
            if (this.consumeChar('=')) {
                int startPattern = this.position;
                int captureCount = 0;
                while (this.consumeChar('*')) {
                    ++captureCount;
                }
                if (captureCount <= 0 || captureCount > 2) {
                    this.errors.reportError("Invalid capture expression, expected * or **.", String.valueOf(this.input.charAt(startPattern)), startPattern);
                }
                boolean bl = multiSegment = captureCount >= 2;
            }
            if (!this.matchesChar('}')) {
                this.errors.reportError("Expected '}' at end of capture expression.", this.currCharOrEof(), this.position);
            } else {
                ++this.position;
            }
            return CaptureNode.create(variableId, start, multiSegment);
        }

        private boolean consumeChar(CharMatcher charMatcher) {
            if (!this.eof() && charMatcher.matches(this.currChar())) {
                ++this.position;
                return true;
            }
            return false;
        }

        private boolean consumeChar(char c) {
            if (!this.eof() && c == this.currChar()) {
                ++this.position;
                return true;
            }
            return false;
        }

        private boolean matchesChar(CharMatcher charMatcher) {
            return !this.eof() && charMatcher.matches(this.currChar());
        }

        private boolean matchesChar(char c) {
            return !this.eof() && c == this.currChar();
        }

        private String currCharOrEof() {
            return this.eof() ? "<eof>" : String.valueOf(this.currChar());
        }

        private char currChar() {
            return this.input.charAt(this.position);
        }

        private boolean eof() {
            return this.position == this.inputLength;
        }

        @FunctionalInterface
        private static interface CharMatcher {
            public boolean matches(char var1);
        }
    }

    @AutoValue
    static abstract class CaptureNode
    implements PathNode {
        CaptureNode() {
        }

        @Override
        public abstract CharSequence text();

        @Override
        public abstract int offset();

        public abstract boolean multiSegment();

        public String toString() {
            return String.format("(%d:MATCH_%s %s)", this.offset(), this.multiSegment() ? "MANY" : "ANY", this.text());
        }

        public static CaptureNode create(CharSequence text, int offset, boolean multiSegment) {
            return new AutoValue_PathParser_CaptureNode(text, offset, multiSegment);
        }
    }

    @AutoValue
    static abstract class SegmentNode
    implements PathNode {
        SegmentNode() {
        }

        @Override
        public abstract CharSequence text();

        @Override
        public abstract int offset();

        public String toString() {
            return String.format("(%d:SEGMENT %s)", this.offset(), this.text());
        }

        public static SegmentNode create(CharSequence text, int offset) {
            return new AutoValue_PathParser_SegmentNode(text, offset);
        }
    }

    public static interface PathNode {
        public int offset();

        public CharSequence text();
    }

    @AutoValue
    public static abstract class ParseResult {
        public static ParseResult create(List<PathNode> pathNodes, List<ParseError> parseErrors) {
            return new AutoValue_PathParser_ParseResult(pathNodes, parseErrors);
        }

        public abstract List<PathNode> pathNodes();

        public abstract List<ParseError> errors();

        public boolean isMatcher() {
            return !this.matchVariables().isEmpty();
        }

        public List<String> matchVariables() {
            return this.pathNodes().stream().filter(node -> node instanceof CaptureNode).map(node -> node.text().toString()).collect(Collectors.toList());
        }

        public String errorMessage() {
            return this.errors().stream().map(ParseError::toString).collect(Collectors.joining("\n"));
        }
    }

    @AutoValue
    public static abstract class ParseError {
        public static ParseError create(String errorMessage, CharSequence parseText, int offset) {
            return new AutoValue_PathParser_ParseError(errorMessage, parseText.toString(), offset);
        }

        public abstract String errorMessage();

        public abstract String parseText();

        public abstract int offset();

        public String toString() {
            return String.format("[%d:%s] %s", this.offset(), this.parseText(), this.errorMessage());
        }
    }
}

