/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.eventflow.client.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.eventflow.client.path.Path;
import com.google.firebase.rules.eventflow.client.path.PathMatcher;
import com.google.firebase.rules.eventflow.client.path.PathParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class PathPattern {
    private PathPattern() {
    }

    public static PathMatcher compile(CharSequence pattern, Function<String, String> segmentDecoder) {
        Preconditions.checkArgument(pattern.length() > 0, "Invalid pattern. Reason: pattern must not be empty string");
        PathParser.ParseResult parseResult = PathParser.parse(pattern, segmentDecoder);
        String string = String.valueOf(parseResult.errorMessage());
        Preconditions.checkArgument(parseResult.errors().isEmpty(), string.length() != 0 ? "Invalid pattern. Reason: ".concat(string) : new String("Invalid pattern. Reason: "));
        List<PathParser.PathNode> pathNodes = parseResult.pathNodes();
        Iterator<PathParser.PathNode> pathNodeIterator = pathNodes.iterator();
        ArrayList<SegmentMatcher> patterns = new ArrayList<SegmentMatcher>();
        PathParser.PathNode multiSegmentNode = PathPattern.compileSingleSegmentPattern(pathNodeIterator, patterns);
        int multiSegmentPatternIndex = -1;
        if (multiSegmentNode != null) {
            multiSegmentPatternIndex = patterns.size();
            SegmentCapture segmentCapture = new SegmentCapture(multiSegmentNode.text(), true);
            patterns.add(segmentCapture);
            if (pathNodeIterator.hasNext()) {
                PathPattern.compileSingleSegmentPattern(pathNodeIterator, patterns);
            }
        }
        Preconditions.checkState(!pathNodeIterator.hasNext(), "Could not compile path");
        return multiSegmentPatternIndex >= 0 ? new MultiSegmentMatcher(patterns, multiSegmentPatternIndex) : new SingleSegmentMatcher(patterns);
    }

    @Nullable
    private static PathParser.PathNode compileSingleSegmentPattern(Iterator<PathParser.PathNode> pathNodeIterator, List<SegmentMatcher> patterns) {
        while (pathNodeIterator.hasNext()) {
            PathParser.PathNode node = pathNodeIterator.next();
            if (node instanceof PathParser.SegmentNode) {
                patterns.add(new SegmentEquals(node.text()));
                continue;
            }
            PathParser.CaptureNode capture = (PathParser.CaptureNode)node;
            if (capture.multiSegment()) {
                return capture;
            }
            patterns.add(new SegmentCapture(node.text()));
        }
        return null;
    }

    private static PathMatcher.PathMatch matches(int segmentOffset, List<CharSequence> segments, List<SegmentMatcher> patterns) {
        if (segments.size() != patterns.size()) {
            return null;
        }
        ArrayList<PathMatcher.Variable> variables = new ArrayList<PathMatcher.Variable>();
        for (int i = 0; i < segments.size(); ++i) {
            CharSequence segment = segments.get(i);
            SegmentMatcher pattern = patterns.get(i);
            if (!pattern.matches(segment)) {
                return null;
            }
            if (pattern.variableId() == null) continue;
            variables.add(PathMatcher.Variable.create(pattern.variableId(), segmentOffset + i, Path.segment(segment)));
        }
        PathMatcher.PathMatch.Builder pathMatch = PathMatcher.PathMatch.builder();
        pathMatch.variablesBuilder().addAll(variables);
        return pathMatch.build();
    }

    static class SegmentCapture
    implements SegmentMatcher {
        private final String variableId;
        private final boolean multiSegment;

        SegmentCapture(CharSequence variableId) {
            this(variableId, false);
        }

        SegmentCapture(CharSequence variableId, boolean multiSegment) {
            this.variableId = variableId.toString();
            this.multiSegment = multiSegment;
        }

        @Override
        public String variableId() {
            return this.variableId;
        }

        @Override
        public boolean matches(CharSequence segment) {
            return true;
        }

        public String toString() {
            String string;
            if (this.multiSegment) {
                String string2 = this.variableId();
                string = new StringBuilder(6 + String.valueOf(string2).length()).append("/{").append(string2).append("=**}").toString();
            } else {
                String string3 = this.variableId();
                string = new StringBuilder(3 + String.valueOf(string3).length()).append("/{").append(string3).append("}").toString();
            }
            return string;
        }
    }

    static class SegmentEquals
    implements SegmentMatcher {
        private final String segment;

        SegmentEquals(CharSequence segment) {
            this.segment = segment.toString();
        }

        @Override
        @Nullable
        public String variableId() {
            return null;
        }

        @Override
        public boolean matches(CharSequence inputSegment) {
            return this.segment.equals(inputSegment);
        }

        public String toString() {
            String string = String.valueOf(this.segment);
            return string.length() != 0 ? "/".concat(string) : new String("/");
        }
    }

    static interface SegmentMatcher {
        @Nullable
        public String variableId();

        public boolean matches(CharSequence var1);
    }

    private static class MultiSegmentMatcher
    implements PathMatcher {
        private final SegmentMatcher multiSegmentMatcher;
        private final List<SegmentMatcher> patterns;
        private final List<SegmentMatcher> headPatterns;
        private final List<SegmentMatcher> tailPatterns;
        private final int multiSegmentPatternIndex;

        private MultiSegmentMatcher(List<SegmentMatcher> segmentMatchers, int multiSegmentPatternIndex) {
            this.patterns = segmentMatchers;
            this.headPatterns = segmentMatchers.subList(0, multiSegmentPatternIndex);
            this.tailPatterns = segmentMatchers.subList(multiSegmentPatternIndex + 1, segmentMatchers.size());
            this.multiSegmentMatcher = segmentMatchers.get(multiSegmentPatternIndex);
            this.multiSegmentPatternIndex = multiSegmentPatternIndex;
        }

        @Override
        @Nullable
        public PathMatcher.PathMatch matches(Path path) {
            int tailPatternCount;
            int headPatternCount;
            ImmutableList<CharSequence> segments = path.segments();
            int segmentCount = segments.size();
            if (segmentCount < (headPatternCount = this.headPatterns.size()) + (tailPatternCount = this.tailPatterns.size())) {
                return null;
            }
            PathMatcher.PathMatch headMatch = PathPattern.matches(0, segments.subList(0, this.multiSegmentPatternIndex), this.headPatterns);
            if (headMatch == null) {
                return null;
            }
            PathMatcher.PathMatch tailMatch = PathPattern.matches(segmentCount - tailPatternCount, segments.subList(segmentCount - tailPatternCount, segmentCount), this.tailPatterns);
            if (tailMatch == null) {
                return null;
            }
            List midSegments = segments.subList(headPatternCount, segmentCount - tailPatternCount);
            PathMatcher.Variable midSegmentMatch = PathMatcher.Variable.create(this.multiSegmentMatcher.variableId(), headPatternCount, Path.segments(midSegments));
            PathMatcher.PathMatch.Builder pathMatch = PathMatcher.PathMatch.builder();
            ((ImmutableList.Builder)((ImmutableList.Builder)pathMatch.variablesBuilder().addAll(headMatch.variables())).add(midSegmentMatch)).addAll(tailMatch.variables());
            return pathMatch.build();
        }

        public String toString() {
            return this.patterns.stream().map(pattern -> pattern.toString()).collect(Collectors.joining());
        }
    }

    private static class SingleSegmentMatcher
    implements PathMatcher {
        private final List<SegmentMatcher> patterns;

        private SingleSegmentMatcher(List<SegmentMatcher> patterns) {
            this.patterns = patterns;
        }

        @Override
        @Nullable
        public PathMatcher.PathMatch matches(Path path) {
            return PathPattern.matches(0, path.segments(), this.patterns);
        }
    }
}

