/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.Metadata;
import com.google.firebase.rules.Policy;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.policy.RulesAstToPolicyConverter;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.Issue;
import java.util.List;
import java.util.function.Supplier;

public class CompileResult {
    private final RulesetAst rulesetAst;
    private final List<Issue> issues;
    private final ParserStrategy parserStrategy;
    private final boolean hasError;
    private final boolean includeSourceOffset;
    private final ImmutableList<File> files;
    private final Supplier<PolicyAndMetadata> lazyPolicyAndMetadata;

    public CompileResult(RulesetAst rulesetAst, List<Issue> issues, ParserStrategy parserStrategy, boolean includeSourceOffset, ImmutableList<File> files) {
        this.issues = issues;
        this.hasError = CompilationIssueUtils.hasCompileError(issues);
        this.includeSourceOffset = includeSourceOffset;
        this.files = files;
        this.rulesetAst = this.hasError ? RulesetAst.getDefaultInstance() : rulesetAst;
        this.parserStrategy = parserStrategy;
        this.lazyPolicyAndMetadata = Suppliers.memoize(this::generatePolicyAndMetadata);
    }

    public RulesetAst getRulesetAst() {
        return this.rulesetAst;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public ParserStrategy getParserStrategy() {
        return this.parserStrategy;
    }

    public boolean hasCompilationError() {
        return this.hasError;
    }

    public PolicyAndMetadata getPolicyAndMetadata() {
        Preconditions.checkState(this.includeSourceOffset, "Cannot generate the policy if the source offsets are not included.");
        Preconditions.checkState(!this.hasError, "Cannot generate the compilation had an error.");
        return this.lazyPolicyAndMetadata.get();
    }

    private PolicyAndMetadata generatePolicyAndMetadata() {
        RulesAstToPolicyConverter rulesAstToPolicyConverter = new RulesAstToPolicyConverter(this.rulesetAst, this.files);
        Policy policy = rulesAstToPolicyConverter.getPolicy();
        Metadata metadata = rulesAstToPolicyConverter.getMetadata();
        return new PolicyAndMetadata(policy, metadata);
    }

    public String toString() {
        return MoreObjects.toStringHelper(CompileResult.class).add("rulesetAst", this.rulesetAst).add("issues", this.issues).add("parserStrategy", (Object)this.parserStrategy).toString();
    }

    public static class PolicyAndMetadata {
        private final Policy policy;
        private final Metadata metadata;

        PolicyAndMetadata(Policy policy, Metadata metadata) {
            this.policy = policy;
            this.metadata = metadata;
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }
    }

    public static enum ParserStrategy {
        LL,
        SLL;

    }
}

